/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types.LobbyGroupRegion;
import com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types.LobbyGroupRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LobbyGroup {
    private final String nameId;
    private final List<LobbyGroupRegion> regions;
    private final int maxPlayersNormal;
    private final int maxPlayersDirect;
    private final int maxPlayersParty;
    private final LobbyGroupRuntime runtime;

    private LobbyGroup(String nameId, List<LobbyGroupRegion> regions, int maxPlayersNormal, int maxPlayersDirect, int maxPlayersParty, LobbyGroupRuntime runtime) {
        this.nameId = nameId;
        this.regions = regions;
        this.maxPlayersNormal = maxPlayersNormal;
        this.maxPlayersDirect = maxPlayersDirect;
        this.maxPlayersParty = maxPlayersParty;
        this.runtime = runtime;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="regions")
    public List<LobbyGroupRegion> getRegions() {
        return this.regions;
    }

    @JsonProperty(value="max_players_normal")
    public int getMaxPlayersNormal() {
        return this.maxPlayersNormal;
    }

    @JsonProperty(value="max_players_direct")
    public int getMaxPlayersDirect() {
        return this.maxPlayersDirect;
    }

    @JsonProperty(value="max_players_party")
    public int getMaxPlayersParty() {
        return this.maxPlayersParty;
    }

    @JsonProperty(value="runtime")
    public LobbyGroupRuntime getRuntime() {
        return this.runtime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LobbyGroup && this.equalTo((LobbyGroup)other);
    }

    private boolean equalTo(LobbyGroup other) {
        return this.nameId.equals(other.nameId) && this.regions.equals(other.regions) && this.maxPlayersNormal == other.maxPlayersNormal && this.maxPlayersDirect == other.maxPlayersDirect && this.maxPlayersParty == other.maxPlayersParty && this.runtime.equals(other.runtime);
    }

    public int hashCode() {
        return Objects.hash(this.nameId, this.regions, this.maxPlayersNormal, this.maxPlayersDirect, this.maxPlayersParty, this.runtime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameIdStage,
    MaxPlayersNormalStage,
    MaxPlayersDirectStage,
    MaxPlayersPartyStage,
    RuntimeStage,
    _FinalStage {
        private String nameId;
        private int maxPlayersNormal;
        private int maxPlayersDirect;
        private int maxPlayersParty;
        private LobbyGroupRuntime runtime;
        private List<LobbyGroupRegion> regions = new ArrayList<LobbyGroupRegion>();

        private Builder() {
        }

        @Override
        public Builder from(LobbyGroup other) {
            this.nameId(other.getNameId());
            this.regions(other.getRegions());
            this.maxPlayersNormal(other.getMaxPlayersNormal());
            this.maxPlayersDirect(other.getMaxPlayersDirect());
            this.maxPlayersParty(other.getMaxPlayersParty());
            this.runtime(other.getRuntime());
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public MaxPlayersNormalStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_normal")
        public MaxPlayersDirectStage maxPlayersNormal(int maxPlayersNormal) {
            this.maxPlayersNormal = maxPlayersNormal;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_direct")
        public MaxPlayersPartyStage maxPlayersDirect(int maxPlayersDirect) {
            this.maxPlayersDirect = maxPlayersDirect;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_party")
        public RuntimeStage maxPlayersParty(int maxPlayersParty) {
            this.maxPlayersParty = maxPlayersParty;
            return this;
        }

        @Override
        @JsonSetter(value="runtime")
        public _FinalStage runtime(LobbyGroupRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public _FinalStage addAllRegions(List<LobbyGroupRegion> regions) {
            this.regions.addAll(regions);
            return this;
        }

        @Override
        public _FinalStage addRegions(LobbyGroupRegion regions) {
            this.regions.add(regions);
            return this;
        }

        @Override
        @JsonSetter(value="regions", nulls=Nulls.SKIP)
        public _FinalStage regions(List<LobbyGroupRegion> regions) {
            this.regions.clear();
            this.regions.addAll(regions);
            return this;
        }

        @Override
        public LobbyGroup build() {
            return new LobbyGroup(this.nameId, this.regions, this.maxPlayersNormal, this.maxPlayersDirect, this.maxPlayersParty, this.runtime);
        }
    }

    public static interface _FinalStage {
        public LobbyGroup build();

        public _FinalStage regions(List<LobbyGroupRegion> var1);

        public _FinalStage addRegions(LobbyGroupRegion var1);

        public _FinalStage addAllRegions(List<LobbyGroupRegion> var1);
    }

    public static interface RuntimeStage {
        public _FinalStage runtime(LobbyGroupRuntime var1);
    }

    public static interface MaxPlayersPartyStage {
        public RuntimeStage maxPlayersParty(int var1);
    }

    public static interface MaxPlayersDirectStage {
        public MaxPlayersPartyStage maxPlayersDirect(int var1);
    }

    public static interface MaxPlayersNormalStage {
        public MaxPlayersDirectStage maxPlayersNormal(int var1);
    }

    public static interface NameIdStage {
        public MaxPlayersNormalStage nameId(String var1);

        public Builder from(LobbyGroup var1);
    }
}

