/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.matchmaker.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetLobbyLogsResponse {
    private final List<String> lines;
    private final List<String> timestamps;
    private final WatchResponse watch;

    private GetLobbyLogsResponse(List<String> lines, List<String> timestamps, WatchResponse watch) {
        this.lines = lines;
        this.timestamps = timestamps;
        this.watch = watch;
    }

    @JsonProperty(value="lines")
    public List<String> getLines() {
        return this.lines;
    }

    @JsonProperty(value="timestamps")
    public List<String> getTimestamps() {
        return this.timestamps;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetLobbyLogsResponse && this.equalTo((GetLobbyLogsResponse)other);
    }

    private boolean equalTo(GetLobbyLogsResponse other) {
        return this.lines.equals(other.lines) && this.timestamps.equals(other.timestamps) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.lines, this.timestamps, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private List<String> timestamps = new ArrayList<String>();
        private List<String> lines = new ArrayList<String>();

        private Builder() {
        }

        @Override
        public Builder from(GetLobbyLogsResponse other) {
            this.lines(other.getLines());
            this.timestamps(other.getTimestamps());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage addAllTimestamps(List<String> timestamps) {
            this.timestamps.addAll(timestamps);
            return this;
        }

        @Override
        public _FinalStage addTimestamps(String timestamps) {
            this.timestamps.add(timestamps);
            return this;
        }

        @Override
        @JsonSetter(value="timestamps", nulls=Nulls.SKIP)
        public _FinalStage timestamps(List<String> timestamps) {
            this.timestamps.clear();
            this.timestamps.addAll(timestamps);
            return this;
        }

        @Override
        public _FinalStage addAllLines(List<String> lines) {
            this.lines.addAll(lines);
            return this;
        }

        @Override
        public _FinalStage addLines(String lines) {
            this.lines.add(lines);
            return this;
        }

        @Override
        @JsonSetter(value="lines", nulls=Nulls.SKIP)
        public _FinalStage lines(List<String> lines) {
            this.lines.clear();
            this.lines.addAll(lines);
            return this;
        }

        @Override
        public GetLobbyLogsResponse build() {
            return new GetLobbyLogsResponse(this.lines, this.timestamps, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetLobbyLogsResponse build();

        public _FinalStage lines(List<String> var1);

        public _FinalStage addLines(String var1);

        public _FinalStage addAllLines(List<String> var1);

        public _FinalStage timestamps(List<String> var1);

        public _FinalStage addTimestamps(String var1);

        public _FinalStage addAllTimestamps(List<String> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetLobbyLogsResponse var1);
    }
}

