/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.builds.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.upload.common.types.PrepareFile;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateGameBuildRequest {
    private final String displayName;
    private final String imageTag;
    private final PrepareFile imageFile;
    private final Optional<Boolean> multipartUpload;

    private CreateGameBuildRequest(String displayName, String imageTag, PrepareFile imageFile, Optional<Boolean> multipartUpload) {
        this.displayName = displayName;
        this.imageTag = imageTag;
        this.imageFile = imageFile;
        this.multipartUpload = multipartUpload;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="image_tag")
    public String getImageTag() {
        return this.imageTag;
    }

    @JsonProperty(value="image_file")
    public PrepareFile getImageFile() {
        return this.imageFile;
    }

    @JsonProperty(value="multipart_upload")
    public Optional<Boolean> getMultipartUpload() {
        return this.multipartUpload;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGameBuildRequest && this.equalTo((CreateGameBuildRequest)other);
    }

    private boolean equalTo(CreateGameBuildRequest other) {
        return this.displayName.equals(other.displayName) && this.imageTag.equals(other.imageTag) && this.imageFile.equals(other.imageFile) && this.multipartUpload.equals(other.multipartUpload);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.imageTag, this.imageFile, this.multipartUpload);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisplayNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisplayNameStage,
    ImageTagStage,
    ImageFileStage,
    _FinalStage {
        private String displayName;
        private String imageTag;
        private PrepareFile imageFile;
        private Optional<Boolean> multipartUpload = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(CreateGameBuildRequest other) {
            this.displayName(other.getDisplayName());
            this.imageTag(other.getImageTag());
            this.imageFile(other.getImageFile());
            this.multipartUpload(other.getMultipartUpload());
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public ImageTagStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="image_tag")
        public ImageFileStage imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        @Override
        @JsonSetter(value="image_file")
        public _FinalStage imageFile(PrepareFile imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        @Override
        public _FinalStage multipartUpload(Boolean multipartUpload) {
            this.multipartUpload = Optional.of(multipartUpload);
            return this;
        }

        @Override
        @JsonSetter(value="multipart_upload", nulls=Nulls.SKIP)
        public _FinalStage multipartUpload(Optional<Boolean> multipartUpload) {
            this.multipartUpload = multipartUpload;
            return this;
        }

        @Override
        public CreateGameBuildRequest build() {
            return new CreateGameBuildRequest(this.displayName, this.imageTag, this.imageFile, this.multipartUpload);
        }
    }

    public static interface _FinalStage {
        public CreateGameBuildRequest build();

        public _FinalStage multipartUpload(Optional<Boolean> var1);

        public _FinalStage multipartUpload(Boolean var1);
    }

    public static interface ImageFileStage {
        public _FinalStage imageFile(PrepareFile var1);
    }

    public static interface ImageTagStage {
        public ImageFileStage imageTag(String var1);
    }

    public static interface DisplayNameStage {
        public ImageTagStage displayName(String var1);

        public Builder from(CreateGameBuildRequest var1);
    }
}

