/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.avatars.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PrepareCustomAvatarUploadRequest {
    private final String path;
    private final Optional<String> mime;
    private final Optional<Long> contentLength;

    private PrepareCustomAvatarUploadRequest(String path, Optional<String> mime, Optional<Long> contentLength) {
        this.path = path;
        this.mime = mime;
        this.contentLength = contentLength;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="mime")
    public Optional<String> getMime() {
        return this.mime;
    }

    @JsonProperty(value="content_length")
    public Optional<Long> getContentLength() {
        return this.contentLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PrepareCustomAvatarUploadRequest && this.equalTo((PrepareCustomAvatarUploadRequest)other);
    }

    private boolean equalTo(PrepareCustomAvatarUploadRequest other) {
        return this.path.equals(other.path) && this.mime.equals(other.mime) && this.contentLength.equals(other.contentLength);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.mime, this.contentLength);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PathStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PathStage,
    _FinalStage {
        private String path;
        private Optional<Long> contentLength = Optional.empty();
        private Optional<String> mime = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(PrepareCustomAvatarUploadRequest other) {
            this.path(other.getPath());
            this.mime(other.getMime());
            this.contentLength(other.getContentLength());
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public _FinalStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public _FinalStage contentLength(Long contentLength) {
            this.contentLength = Optional.of(contentLength);
            return this;
        }

        @Override
        @JsonSetter(value="content_length", nulls=Nulls.SKIP)
        public _FinalStage contentLength(Optional<Long> contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public _FinalStage mime(String mime) {
            this.mime = Optional.of(mime);
            return this;
        }

        @Override
        @JsonSetter(value="mime", nulls=Nulls.SKIP)
        public _FinalStage mime(Optional<String> mime) {
            this.mime = mime;
            return this;
        }

        @Override
        public PrepareCustomAvatarUploadRequest build() {
            return new PrepareCustomAvatarUploadRequest(this.path, this.mime, this.contentLength);
        }
    }

    public static interface _FinalStage {
        public PrepareCustomAvatarUploadRequest build();

        public _FinalStage mime(Optional<String> var1);

        public _FinalStage mime(String var1);

        public _FinalStage contentLength(Optional<Long> var1);

        public _FinalStage contentLength(Long var1);
    }

    public static interface PathStage {
        public _FinalStage path(String var1);

        public Builder from(PrepareCustomAvatarUploadRequest var1);
    }
}

