/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SvcMetrics {
    private final String job;
    private final List<Double> cpu;
    private final List<Double> memory;
    private final List<Double> memoryMax;
    private final Optional<Double> allocatedMemory;

    private SvcMetrics(String job, List<Double> cpu, List<Double> memory, List<Double> memoryMax, Optional<Double> allocatedMemory) {
        this.job = job;
        this.cpu = cpu;
        this.memory = memory;
        this.memoryMax = memoryMax;
        this.allocatedMemory = allocatedMemory;
    }

    @JsonProperty(value="job")
    public String getJob() {
        return this.job;
    }

    @JsonProperty(value="cpu")
    public List<Double> getCpu() {
        return this.cpu;
    }

    @JsonProperty(value="memory")
    public List<Double> getMemory() {
        return this.memory;
    }

    @JsonProperty(value="memory_max")
    public List<Double> getMemoryMax() {
        return this.memoryMax;
    }

    @JsonProperty(value="allocated_memory")
    public Optional<Double> getAllocatedMemory() {
        return this.allocatedMemory;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SvcMetrics && this.equalTo((SvcMetrics)other);
    }

    private boolean equalTo(SvcMetrics other) {
        return this.job.equals(other.job) && this.cpu.equals(other.cpu) && this.memory.equals(other.memory) && this.memoryMax.equals(other.memoryMax) && this.allocatedMemory.equals(other.allocatedMemory);
    }

    public int hashCode() {
        return Objects.hash(this.job, this.cpu, this.memory, this.memoryMax, this.allocatedMemory);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobStage,
    _FinalStage {
        private String job;
        private Optional<Double> allocatedMemory = Optional.empty();
        private List<Double> memoryMax = new ArrayList<Double>();
        private List<Double> memory = new ArrayList<Double>();
        private List<Double> cpu = new ArrayList<Double>();

        private Builder() {
        }

        @Override
        public Builder from(SvcMetrics other) {
            this.job(other.getJob());
            this.cpu(other.getCpu());
            this.memory(other.getMemory());
            this.memoryMax(other.getMemoryMax());
            this.allocatedMemory(other.getAllocatedMemory());
            return this;
        }

        @Override
        @JsonSetter(value="job")
        public _FinalStage job(String job) {
            this.job = job;
            return this;
        }

        @Override
        public _FinalStage allocatedMemory(Double allocatedMemory) {
            this.allocatedMemory = Optional.of(allocatedMemory);
            return this;
        }

        @Override
        @JsonSetter(value="allocated_memory", nulls=Nulls.SKIP)
        public _FinalStage allocatedMemory(Optional<Double> allocatedMemory) {
            this.allocatedMemory = allocatedMemory;
            return this;
        }

        @Override
        public _FinalStage addAllMemoryMax(List<Double> memoryMax) {
            this.memoryMax.addAll(memoryMax);
            return this;
        }

        @Override
        public _FinalStage addMemoryMax(Double memoryMax) {
            this.memoryMax.add(memoryMax);
            return this;
        }

        @Override
        @JsonSetter(value="memory_max", nulls=Nulls.SKIP)
        public _FinalStage memoryMax(List<Double> memoryMax) {
            this.memoryMax.clear();
            this.memoryMax.addAll(memoryMax);
            return this;
        }

        @Override
        public _FinalStage addAllMemory(List<Double> memory) {
            this.memory.addAll(memory);
            return this;
        }

        @Override
        public _FinalStage addMemory(Double memory) {
            this.memory.add(memory);
            return this;
        }

        @Override
        @JsonSetter(value="memory", nulls=Nulls.SKIP)
        public _FinalStage memory(List<Double> memory) {
            this.memory.clear();
            this.memory.addAll(memory);
            return this;
        }

        @Override
        public _FinalStage addAllCpu(List<Double> cpu) {
            this.cpu.addAll(cpu);
            return this;
        }

        @Override
        public _FinalStage addCpu(Double cpu) {
            this.cpu.add(cpu);
            return this;
        }

        @Override
        @JsonSetter(value="cpu", nulls=Nulls.SKIP)
        public _FinalStage cpu(List<Double> cpu) {
            this.cpu.clear();
            this.cpu.addAll(cpu);
            return this;
        }

        @Override
        public SvcMetrics build() {
            return new SvcMetrics(this.job, this.cpu, this.memory, this.memoryMax, this.allocatedMemory);
        }
    }

    public static interface _FinalStage {
        public SvcMetrics build();

        public _FinalStage cpu(List<Double> var1);

        public _FinalStage addCpu(Double var1);

        public _FinalStage addAllCpu(List<Double> var1);

        public _FinalStage memory(List<Double> var1);

        public _FinalStage addMemory(Double var1);

        public _FinalStage addAllMemory(List<Double> var1);

        public _FinalStage memoryMax(List<Double> var1);

        public _FinalStage addMemoryMax(Double var1);

        public _FinalStage addAllMemoryMax(List<Double> var1);

        public _FinalStage allocatedMemory(Optional<Double> var1);

        public _FinalStage allocatedMemory(Double var1);
    }

    public static interface JobStage {
        public _FinalStage job(String var1);

        public Builder from(SvcMetrics var1);
    }
}

