/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class NamespaceSummary {
    private final UUID namespaceId;
    private final OffsetDateTime createTs;
    private final String displayName;
    private final UUID versionId;
    private final String nameId;

    private NamespaceSummary(UUID namespaceId, OffsetDateTime createTs, String displayName, UUID versionId, String nameId) {
        this.namespaceId = namespaceId;
        this.createTs = createTs;
        this.displayName = displayName;
        this.versionId = versionId;
        this.nameId = nameId;
    }

    @JsonProperty(value="namespace_id")
    public UUID getNamespaceId() {
        return this.namespaceId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="version_id")
    public UUID getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NamespaceSummary && this.equalTo((NamespaceSummary)other);
    }

    private boolean equalTo(NamespaceSummary other) {
        return this.namespaceId.equals(other.namespaceId) && this.createTs.equals(other.createTs) && this.displayName.equals(other.displayName) && this.versionId.equals(other.versionId) && this.nameId.equals(other.nameId);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.createTs, this.displayName, this.versionId, this.nameId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NamespaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NamespaceIdStage,
    CreateTsStage,
    DisplayNameStage,
    VersionIdStage,
    NameIdStage,
    _FinalStage {
        private UUID namespaceId;
        private OffsetDateTime createTs;
        private String displayName;
        private UUID versionId;
        private String nameId;

        private Builder() {
        }

        @Override
        public Builder from(NamespaceSummary other) {
            this.namespaceId(other.getNamespaceId());
            this.createTs(other.getCreateTs());
            this.displayName(other.getDisplayName());
            this.versionId(other.getVersionId());
            this.nameId(other.getNameId());
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id")
        public CreateTsStage namespaceId(UUID namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public DisplayNameStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public VersionIdStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="version_id")
        public NameIdStage versionId(UUID versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public _FinalStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        public NamespaceSummary build() {
            return new NamespaceSummary(this.namespaceId, this.createTs, this.displayName, this.versionId, this.nameId);
        }
    }

    public static interface _FinalStage {
        public NamespaceSummary build();
    }

    public static interface NameIdStage {
        public _FinalStage nameId(String var1);
    }

    public static interface VersionIdStage {
        public NameIdStage versionId(UUID var1);
    }

    public static interface DisplayNameStage {
        public VersionIdStage displayName(String var1);
    }

    public static interface CreateTsStage {
        public DisplayNameStage createTs(OffsetDateTime var1);
    }

    public static interface NamespaceIdStage {
        public CreateTsStage namespaceId(UUID var1);

        public Builder from(NamespaceSummary var1);
    }
}

