/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LogsPerfMark {
    private final String label;
    private final OffsetDateTime ts;
    private final Optional<UUID> rayId;
    private final Optional<UUID> reqId;

    private LogsPerfMark(String label, OffsetDateTime ts, Optional<UUID> rayId, Optional<UUID> reqId) {
        this.label = label;
        this.ts = ts;
        this.rayId = rayId;
        this.reqId = reqId;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="ts")
    public OffsetDateTime getTs() {
        return this.ts;
    }

    @JsonProperty(value="ray_id")
    public Optional<UUID> getRayId() {
        return this.rayId;
    }

    @JsonProperty(value="req_id")
    public Optional<UUID> getReqId() {
        return this.reqId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LogsPerfMark && this.equalTo((LogsPerfMark)other);
    }

    private boolean equalTo(LogsPerfMark other) {
        return this.label.equals(other.label) && this.ts.equals(other.ts) && this.rayId.equals(other.rayId) && this.reqId.equals(other.reqId);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.ts, this.rayId, this.reqId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LabelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LabelStage,
    TsStage,
    _FinalStage {
        private String label;
        private OffsetDateTime ts;
        private Optional<UUID> reqId = Optional.empty();
        private Optional<UUID> rayId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LogsPerfMark other) {
            this.label(other.getLabel());
            this.ts(other.getTs());
            this.rayId(other.getRayId());
            this.reqId(other.getReqId());
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public TsStage label(String label) {
            this.label = label;
            return this;
        }

        @Override
        @JsonSetter(value="ts")
        public _FinalStage ts(OffsetDateTime ts) {
            this.ts = ts;
            return this;
        }

        @Override
        public _FinalStage reqId(UUID reqId) {
            this.reqId = Optional.of(reqId);
            return this;
        }

        @Override
        @JsonSetter(value="req_id", nulls=Nulls.SKIP)
        public _FinalStage reqId(Optional<UUID> reqId) {
            this.reqId = reqId;
            return this;
        }

        @Override
        public _FinalStage rayId(UUID rayId) {
            this.rayId = Optional.of(rayId);
            return this;
        }

        @Override
        @JsonSetter(value="ray_id", nulls=Nulls.SKIP)
        public _FinalStage rayId(Optional<UUID> rayId) {
            this.rayId = rayId;
            return this;
        }

        @Override
        public LogsPerfMark build() {
            return new LogsPerfMark(this.label, this.ts, this.rayId, this.reqId);
        }
    }

    public static interface _FinalStage {
        public LogsPerfMark build();

        public _FinalStage rayId(Optional<UUID> var1);

        public _FinalStage rayId(UUID var1);

        public _FinalStage reqId(Optional<UUID> var1);

        public _FinalStage reqId(UUID var1);
    }

    public static interface TsStage {
        public _FinalStage ts(OffsetDateTime var1);
    }

    public static interface LabelStage {
        public TsStage label(String var1);

        public Builder from(LogsPerfMark var1);
    }
}

