/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.chat.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SimpleTopicDirect {
    private final UUID identityA;
    private final UUID identityB;

    private SimpleTopicDirect(UUID identityA, UUID identityB) {
        this.identityA = identityA;
        this.identityB = identityB;
    }

    @JsonProperty(value="identity_a")
    public UUID getIdentityA() {
        return this.identityA;
    }

    @JsonProperty(value="identity_b")
    public UUID getIdentityB() {
        return this.identityB;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SimpleTopicDirect && this.equalTo((SimpleTopicDirect)other);
    }

    private boolean equalTo(SimpleTopicDirect other) {
        return this.identityA.equals(other.identityA) && this.identityB.equals(other.identityB);
    }

    public int hashCode() {
        return Objects.hash(this.identityA, this.identityB);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityAStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityAStage,
    IdentityBStage,
    _FinalStage {
        private UUID identityA;
        private UUID identityB;

        private Builder() {
        }

        @Override
        public Builder from(SimpleTopicDirect other) {
            this.identityA(other.getIdentityA());
            this.identityB(other.getIdentityB());
            return this;
        }

        @Override
        @JsonSetter(value="identity_a")
        public IdentityBStage identityA(UUID identityA) {
            this.identityA = identityA;
            return this;
        }

        @Override
        @JsonSetter(value="identity_b")
        public _FinalStage identityB(UUID identityB) {
            this.identityB = identityB;
            return this;
        }

        @Override
        public SimpleTopicDirect build() {
            return new SimpleTopicDirect(this.identityA, this.identityB);
        }
    }

    public static interface _FinalStage {
        public SimpleTopicDirect build();
    }

    public static interface IdentityBStage {
        public _FinalStage identityB(UUID var1);
    }

    public static interface IdentityAStage {
        public IdentityBStage identityA(UUID var1);

        public Builder from(SimpleTopicDirect var1);
    }
}

