/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.upload.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PresignedRequest {
    private final String path;
    private final String url;
    private final long byteOffset;
    private final long contentLength;

    private PresignedRequest(String path, String url, long byteOffset, long contentLength) {
        this.path = path;
        this.url = url;
        this.byteOffset = byteOffset;
        this.contentLength = contentLength;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="byte_offset")
    public long getByteOffset() {
        return this.byteOffset;
    }

    @JsonProperty(value="content_length")
    public long getContentLength() {
        return this.contentLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PresignedRequest && this.equalTo((PresignedRequest)other);
    }

    private boolean equalTo(PresignedRequest other) {
        return this.path.equals(other.path) && this.url.equals(other.url) && this.byteOffset == other.byteOffset && this.contentLength == other.contentLength;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.url, this.byteOffset, this.contentLength);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PathStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PathStage,
    UrlStage,
    ByteOffsetStage,
    ContentLengthStage,
    _FinalStage {
        private String path;
        private String url;
        private long byteOffset;
        private long contentLength;

        private Builder() {
        }

        @Override
        public Builder from(PresignedRequest other) {
            this.path(other.getPath());
            this.url(other.getUrl());
            this.byteOffset(other.getByteOffset());
            this.contentLength(other.getContentLength());
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public UrlStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public ByteOffsetStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @JsonSetter(value="byte_offset")
        public ContentLengthStage byteOffset(long byteOffset) {
            this.byteOffset = byteOffset;
            return this;
        }

        @Override
        @JsonSetter(value="content_length")
        public _FinalStage contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public PresignedRequest build() {
            return new PresignedRequest(this.path, this.url, this.byteOffset, this.contentLength);
        }
    }

    public static interface _FinalStage {
        public PresignedRequest build();
    }

    public static interface ContentLengthStage {
        public _FinalStage contentLength(long var1);
    }

    public static interface ByteOffsetStage {
        public ContentLengthStage byteOffset(long var1);
    }

    public static interface UrlStage {
        public ByteOffsetStage url(String var1);
    }

    public static interface PathStage {
        public UrlStage path(String var1);

        public Builder from(PresignedRequest var1);
    }
}

