/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.players.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.matchmaker.players.types.GameModeStatistics;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetStatisticsResponse {
    private final long playerCount;
    private final Map<String, GameModeStatistics> gameModes;

    private GetStatisticsResponse(long playerCount, Map<String, GameModeStatistics> gameModes) {
        this.playerCount = playerCount;
        this.gameModes = gameModes;
    }

    @JsonProperty(value="player_count")
    public long getPlayerCount() {
        return this.playerCount;
    }

    @JsonProperty(value="game_modes")
    public Map<String, GameModeStatistics> getGameModes() {
        return this.gameModes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetStatisticsResponse && this.equalTo((GetStatisticsResponse)other);
    }

    private boolean equalTo(GetStatisticsResponse other) {
        return this.playerCount == other.playerCount && this.gameModes.equals(other.gameModes);
    }

    public int hashCode() {
        return Objects.hash(this.playerCount, this.gameModes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlayerCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlayerCountStage,
    _FinalStage {
        private long playerCount;
        private Map<String, GameModeStatistics> gameModes = new LinkedHashMap<String, GameModeStatistics>();

        private Builder() {
        }

        @Override
        public Builder from(GetStatisticsResponse other) {
            this.playerCount(other.getPlayerCount());
            this.gameModes(other.getGameModes());
            return this;
        }

        @Override
        @JsonSetter(value="player_count")
        public _FinalStage playerCount(long playerCount) {
            this.playerCount = playerCount;
            return this;
        }

        @Override
        public _FinalStage gameModes(String key, GameModeStatistics value) {
            this.gameModes.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllGameModes(Map<String, GameModeStatistics> gameModes) {
            this.gameModes.putAll(gameModes);
            return this;
        }

        @Override
        @JsonSetter(value="game_modes", nulls=Nulls.SKIP)
        public _FinalStage gameModes(Map<String, GameModeStatistics> gameModes) {
            this.gameModes.clear();
            this.gameModes.putAll(gameModes);
            return this;
        }

        @Override
        public GetStatisticsResponse build() {
            return new GetStatisticsResponse(this.playerCount, this.gameModes);
        }
    }

    public static interface _FinalStage {
        public GetStatisticsResponse build();

        public _FinalStage gameModes(Map<String, GameModeStatistics> var1);

        public _FinalStage putAllGameModes(Map<String, GameModeStatistics> var1);

        public _FinalStage gameModes(String var1, GameModeStatistics var2);
    }

    public static interface PlayerCountStage {
        public _FinalStage playerCount(long var1);

        public Builder from(GetStatisticsResponse var1);
    }
}

