/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.players;

import com.rivet.api.core.ApiError;
import com.rivet.api.core.ClientOptions;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.core.RequestOptions;
import com.rivet.api.resources.matchmaker.players.requests.PlayerConnectedRequest;
import com.rivet.api.resources.matchmaker.players.requests.PlayerDisconnectedRequest;
import com.rivet.api.resources.matchmaker.players.types.GetStatisticsResponse;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class PlayersClient {
    protected final ClientOptions clientOptions;

    public PlayersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public void connected(PlayerConnectedRequest request) {
        this.connected(request, null);
    }

    public void connected(PlayerConnectedRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("matchmaker/players").addPathSegments("connected").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("player_token", request.getPlayerToken());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new ApiError(_response.code(), ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void disconnected(PlayerDisconnectedRequest request) {
        this.disconnected(request, null);
    }

    public void disconnected(PlayerDisconnectedRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("matchmaker/players").addPathSegments("disconnected").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("player_token", request.getPlayerToken());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new ApiError(_response.code(), ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GetStatisticsResponse getStatistics() {
        return this.getStatistics(null);
    }

    public GetStatisticsResponse getStatistics(RequestOptions requestOptions) {
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("matchmaker/players").addPathSegments("statistics").build();
        Request _request = new Request.Builder().url(_httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (GetStatisticsResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), GetStatisticsResponse.class);
            }
            throw new ApiError(_response.code(), ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

