/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.geo.common.types.Coord;
import com.rivet.api.resources.geo.common.types.Distance;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RegionInfo {
    private final String regionId;
    private final String providerDisplayName;
    private final String regionDisplayName;
    private final Coord datacenterCoord;
    private final Distance datacenterDistanceFromClient;

    private RegionInfo(String regionId, String providerDisplayName, String regionDisplayName, Coord datacenterCoord, Distance datacenterDistanceFromClient) {
        this.regionId = regionId;
        this.providerDisplayName = providerDisplayName;
        this.regionDisplayName = regionDisplayName;
        this.datacenterCoord = datacenterCoord;
        this.datacenterDistanceFromClient = datacenterDistanceFromClient;
    }

    @JsonProperty(value="region_id")
    public String getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="provider_display_name")
    public String getProviderDisplayName() {
        return this.providerDisplayName;
    }

    @JsonProperty(value="region_display_name")
    public String getRegionDisplayName() {
        return this.regionDisplayName;
    }

    @JsonProperty(value="datacenter_coord")
    public Coord getDatacenterCoord() {
        return this.datacenterCoord;
    }

    @JsonProperty(value="datacenter_distance_from_client")
    public Distance getDatacenterDistanceFromClient() {
        return this.datacenterDistanceFromClient;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RegionInfo && this.equalTo((RegionInfo)other);
    }

    private boolean equalTo(RegionInfo other) {
        return this.regionId.equals(other.regionId) && this.providerDisplayName.equals(other.providerDisplayName) && this.regionDisplayName.equals(other.regionDisplayName) && this.datacenterCoord.equals(other.datacenterCoord) && this.datacenterDistanceFromClient.equals(other.datacenterDistanceFromClient);
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.providerDisplayName, this.regionDisplayName, this.datacenterCoord, this.datacenterDistanceFromClient);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RegionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RegionIdStage,
    ProviderDisplayNameStage,
    RegionDisplayNameStage,
    DatacenterCoordStage,
    DatacenterDistanceFromClientStage,
    _FinalStage {
        private String regionId;
        private String providerDisplayName;
        private String regionDisplayName;
        private Coord datacenterCoord;
        private Distance datacenterDistanceFromClient;

        private Builder() {
        }

        @Override
        public Builder from(RegionInfo other) {
            this.regionId(other.getRegionId());
            this.providerDisplayName(other.getProviderDisplayName());
            this.regionDisplayName(other.getRegionDisplayName());
            this.datacenterCoord(other.getDatacenterCoord());
            this.datacenterDistanceFromClient(other.getDatacenterDistanceFromClient());
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public ProviderDisplayNameStage regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="provider_display_name")
        public RegionDisplayNameStage providerDisplayName(String providerDisplayName) {
            this.providerDisplayName = providerDisplayName;
            return this;
        }

        @Override
        @JsonSetter(value="region_display_name")
        public DatacenterCoordStage regionDisplayName(String regionDisplayName) {
            this.regionDisplayName = regionDisplayName;
            return this;
        }

        @Override
        @JsonSetter(value="datacenter_coord")
        public DatacenterDistanceFromClientStage datacenterCoord(Coord datacenterCoord) {
            this.datacenterCoord = datacenterCoord;
            return this;
        }

        @Override
        @JsonSetter(value="datacenter_distance_from_client")
        public _FinalStage datacenterDistanceFromClient(Distance datacenterDistanceFromClient) {
            this.datacenterDistanceFromClient = datacenterDistanceFromClient;
            return this;
        }

        @Override
        public RegionInfo build() {
            return new RegionInfo(this.regionId, this.providerDisplayName, this.regionDisplayName, this.datacenterCoord, this.datacenterDistanceFromClient);
        }
    }

    public static interface _FinalStage {
        public RegionInfo build();
    }

    public static interface DatacenterDistanceFromClientStage {
        public _FinalStage datacenterDistanceFromClient(Distance var1);
    }

    public static interface DatacenterCoordStage {
        public DatacenterDistanceFromClientStage datacenterCoord(Coord var1);
    }

    public static interface RegionDisplayNameStage {
        public DatacenterCoordStage regionDisplayName(String var1);
    }

    public static interface ProviderDisplayNameStage {
        public RegionDisplayNameStage providerDisplayName(String var1);
    }

    public static interface RegionIdStage {
        public ProviderDisplayNameStage regionId(String var1);

        public Builder from(RegionInfo var1);
    }
}

