/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JoinRegion {
    private final String regionId;
    private final String displayName;

    private JoinRegion(String regionId, String displayName) {
        this.regionId = regionId;
        this.displayName = displayName;
    }

    @JsonProperty(value="region_id")
    public String getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JoinRegion && this.equalTo((JoinRegion)other);
    }

    private boolean equalTo(JoinRegion other) {
        return this.regionId.equals(other.regionId) && this.displayName.equals(other.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.displayName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RegionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RegionIdStage,
    DisplayNameStage,
    _FinalStage {
        private String regionId;
        private String displayName;

        private Builder() {
        }

        @Override
        public Builder from(JoinRegion other) {
            this.regionId(other.getRegionId());
            this.displayName(other.getDisplayName());
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public DisplayNameStage regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public _FinalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public JoinRegion build() {
            return new JoinRegion(this.regionId, this.displayName);
        }
    }

    public static interface _FinalStage {
        public JoinRegion build();
    }

    public static interface DisplayNameStage {
        public _FinalStage displayName(String var1);
    }

    public static interface RegionIdStage {
        public DisplayNameStage regionId(String var1);

        public Builder from(JoinRegion var1);
    }
}

