/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.matchmaker.common.types.JoinPortRange;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JoinPort {
    private final Optional<String> host;
    private final String hostname;
    private final Optional<Integer> port;
    private final Optional<JoinPortRange> portRange;
    private final boolean isTls;

    private JoinPort(Optional<String> host, String hostname, Optional<Integer> port, Optional<JoinPortRange> portRange, boolean isTls) {
        this.host = host;
        this.hostname = hostname;
        this.port = port;
        this.portRange = portRange;
        this.isTls = isTls;
    }

    @JsonProperty(value="host")
    public Optional<String> getHost() {
        return this.host;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="port")
    public Optional<Integer> getPort() {
        return this.port;
    }

    @JsonProperty(value="port_range")
    public Optional<JoinPortRange> getPortRange() {
        return this.portRange;
    }

    @JsonProperty(value="is_tls")
    public boolean getIsTls() {
        return this.isTls;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JoinPort && this.equalTo((JoinPort)other);
    }

    private boolean equalTo(JoinPort other) {
        return this.host.equals(other.host) && this.hostname.equals(other.hostname) && this.port.equals(other.port) && this.portRange.equals(other.portRange) && this.isTls == other.isTls;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.hostname, this.port, this.portRange, this.isTls);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static HostnameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements HostnameStage,
    IsTlsStage,
    _FinalStage {
        private String hostname;
        private boolean isTls;
        private Optional<JoinPortRange> portRange = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<String> host = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(JoinPort other) {
            this.host(other.getHost());
            this.hostname(other.getHostname());
            this.port(other.getPort());
            this.portRange(other.getPortRange());
            this.isTls(other.getIsTls());
            return this;
        }

        @Override
        @JsonSetter(value="hostname")
        public IsTlsStage hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Override
        @JsonSetter(value="is_tls")
        public _FinalStage isTls(boolean isTls) {
            this.isTls = isTls;
            return this;
        }

        @Override
        public _FinalStage portRange(JoinPortRange portRange) {
            this.portRange = Optional.of(portRange);
            return this;
        }

        @Override
        @JsonSetter(value="port_range", nulls=Nulls.SKIP)
        public _FinalStage portRange(Optional<JoinPortRange> portRange) {
            this.portRange = portRange;
            return this;
        }

        @Override
        public _FinalStage port(Integer port) {
            this.port = Optional.of(port);
            return this;
        }

        @Override
        @JsonSetter(value="port", nulls=Nulls.SKIP)
        public _FinalStage port(Optional<Integer> port) {
            this.port = port;
            return this;
        }

        @Override
        public _FinalStage host(String host) {
            this.host = Optional.of(host);
            return this;
        }

        @Override
        @JsonSetter(value="host", nulls=Nulls.SKIP)
        public _FinalStage host(Optional<String> host) {
            this.host = host;
            return this;
        }

        @Override
        public JoinPort build() {
            return new JoinPort(this.host, this.hostname, this.port, this.portRange, this.isTls);
        }
    }

    public static interface _FinalStage {
        public JoinPort build();

        public _FinalStage host(Optional<String> var1);

        public _FinalStage host(String var1);

        public _FinalStage port(Optional<Integer> var1);

        public _FinalStage port(Integer var1);

        public _FinalStage portRange(Optional<JoinPortRange> var1);

        public _FinalStage portRange(JoinPortRange var1);
    }

    public static interface IsTlsStage {
        public _FinalStage isTls(boolean var1);
    }

    public static interface HostnameStage {
        public IsTlsStage hostname(String var1);

        public Builder from(JoinPort var1);
    }
}

