/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PutRequest {
    private final Optional<UUID> namespaceId;
    private final String key;
    private final Object value;

    private PutRequest(Optional<UUID> namespaceId, String key, Object value) {
        this.namespaceId = namespaceId;
        this.key = key;
        this.value = value;
    }

    @JsonProperty(value="namespace_id")
    public Optional<UUID> getNamespaceId() {
        return this.namespaceId;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PutRequest && this.equalTo((PutRequest)other);
    }

    private boolean equalTo(PutRequest other) {
        return this.namespaceId.equals(other.namespaceId) && this.key.equals(other.key) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.key, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    ValueStage,
    _FinalStage {
        private String key;
        private Object value;
        private Optional<UUID> namespaceId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(PutRequest other) {
            this.namespaceId(other.getNamespaceId());
            this.key(other.getKey());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public ValueStage key(String key) {
            this.key = key;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage namespaceId(UUID namespaceId) {
            this.namespaceId = Optional.of(namespaceId);
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id", nulls=Nulls.SKIP)
        public _FinalStage namespaceId(Optional<UUID> namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public PutRequest build() {
            return new PutRequest(this.namespaceId, this.key, this.value);
        }
    }

    public static interface _FinalStage {
        public PutRequest build();

        public _FinalStage namespaceId(Optional<UUID> var1);

        public _FinalStage namespaceId(UUID var1);
    }

    public static interface ValueStage {
        public _FinalStage value(Object var1);
    }

    public static interface KeyStage {
        public ValueStage key(String var1);

        public Builder from(PutRequest var1);
    }
}

