/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.kv.common.types.Entry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetBatchResponse {
    private final List<Entry> entries;
    private final WatchResponse watch;

    private GetBatchResponse(List<Entry> entries, WatchResponse watch) {
        this.entries = entries;
        this.watch = watch;
    }

    @JsonProperty(value="entries")
    public List<Entry> getEntries() {
        return this.entries;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetBatchResponse && this.equalTo((GetBatchResponse)other);
    }

    private boolean equalTo(GetBatchResponse other) {
        return this.entries.equals(other.entries) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.entries, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private List<Entry> entries = new ArrayList<Entry>();

        private Builder() {
        }

        @Override
        public Builder from(GetBatchResponse other) {
            this.entries(other.getEntries());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage addAllEntries(List<Entry> entries) {
            this.entries.addAll(entries);
            return this;
        }

        @Override
        public _FinalStage addEntries(Entry entries) {
            this.entries.add(entries);
            return this;
        }

        @Override
        @JsonSetter(value="entries", nulls=Nulls.SKIP)
        public _FinalStage entries(List<Entry> entries) {
            this.entries.clear();
            this.entries.addAll(entries);
            return this;
        }

        @Override
        public GetBatchResponse build() {
            return new GetBatchResponse(this.entries, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetBatchResponse build();

        public _FinalStage entries(List<Entry> var1);

        public _FinalStage addEntries(Entry var1);

        public _FinalStage addAllEntries(List<Entry> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetBatchResponse var1);
    }
}

