/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.Profile;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SetupResponse {
    private final String identityToken;
    private final OffsetDateTime identityTokenExpireTs;
    private final Profile identity;
    private final UUID gameId;

    private SetupResponse(String identityToken, OffsetDateTime identityTokenExpireTs, Profile identity, UUID gameId) {
        this.identityToken = identityToken;
        this.identityTokenExpireTs = identityTokenExpireTs;
        this.identity = identity;
        this.gameId = gameId;
    }

    @JsonProperty(value="identity_token")
    public String getIdentityToken() {
        return this.identityToken;
    }

    @JsonProperty(value="identity_token_expire_ts")
    public OffsetDateTime getIdentityTokenExpireTs() {
        return this.identityTokenExpireTs;
    }

    @JsonProperty(value="identity")
    public Profile getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="game_id")
    public UUID getGameId() {
        return this.gameId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SetupResponse && this.equalTo((SetupResponse)other);
    }

    private boolean equalTo(SetupResponse other) {
        return this.identityToken.equals(other.identityToken) && this.identityTokenExpireTs.equals(other.identityTokenExpireTs) && this.identity.equals(other.identity) && this.gameId.equals(other.gameId);
    }

    public int hashCode() {
        return Objects.hash(this.identityToken, this.identityTokenExpireTs, this.identity, this.gameId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityTokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityTokenStage,
    IdentityTokenExpireTsStage,
    IdentityStage,
    GameIdStage,
    _FinalStage {
        private String identityToken;
        private OffsetDateTime identityTokenExpireTs;
        private Profile identity;
        private UUID gameId;

        private Builder() {
        }

        @Override
        public Builder from(SetupResponse other) {
            this.identityToken(other.getIdentityToken());
            this.identityTokenExpireTs(other.getIdentityTokenExpireTs());
            this.identity(other.getIdentity());
            this.gameId(other.getGameId());
            return this;
        }

        @Override
        @JsonSetter(value="identity_token")
        public IdentityTokenExpireTsStage identityToken(String identityToken) {
            this.identityToken = identityToken;
            return this;
        }

        @Override
        @JsonSetter(value="identity_token_expire_ts")
        public IdentityStage identityTokenExpireTs(OffsetDateTime identityTokenExpireTs) {
            this.identityTokenExpireTs = identityTokenExpireTs;
            return this;
        }

        @Override
        @JsonSetter(value="identity")
        public GameIdStage identity(Profile identity) {
            this.identity = identity;
            return this;
        }

        @Override
        @JsonSetter(value="game_id")
        public _FinalStage gameId(UUID gameId) {
            this.gameId = gameId;
            return this;
        }

        @Override
        public SetupResponse build() {
            return new SetupResponse(this.identityToken, this.identityTokenExpireTs, this.identity, this.gameId);
        }
    }

    public static interface _FinalStage {
        public SetupResponse build();
    }

    public static interface GameIdStage {
        public _FinalStage gameId(UUID var1);
    }

    public static interface IdentityStage {
        public GameIdStage identity(Profile var1);
    }

    public static interface IdentityTokenExpireTsStage {
        public IdentityStage identityTokenExpireTs(OffsetDateTime var1);
    }

    public static interface IdentityTokenStage {
        public IdentityTokenExpireTsStage identityToken(String var1);

        public Builder from(SetupResponse var1);
    }
}

