/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SignupForBetaRequest {
    private final String name;
    private final Optional<String> companyName;
    private final String companySize;
    private final String preferredTools;
    private final String goals;

    private SignupForBetaRequest(String name, Optional<String> companyName, String companySize, String preferredTools, String goals) {
        this.name = name;
        this.companyName = companyName;
        this.companySize = companySize;
        this.preferredTools = preferredTools;
        this.goals = goals;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="company_name")
    public Optional<String> getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="company_size")
    public String getCompanySize() {
        return this.companySize;
    }

    @JsonProperty(value="preferred_tools")
    public String getPreferredTools() {
        return this.preferredTools;
    }

    @JsonProperty(value="goals")
    public String getGoals() {
        return this.goals;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SignupForBetaRequest && this.equalTo((SignupForBetaRequest)other);
    }

    private boolean equalTo(SignupForBetaRequest other) {
        return this.name.equals(other.name) && this.companyName.equals(other.companyName) && this.companySize.equals(other.companySize) && this.preferredTools.equals(other.preferredTools) && this.goals.equals(other.goals);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.companyName, this.companySize, this.preferredTools, this.goals);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    CompanySizeStage,
    PreferredToolsStage,
    GoalsStage,
    _FinalStage {
        private String name;
        private String companySize;
        private String preferredTools;
        private String goals;
        private Optional<String> companyName = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(SignupForBetaRequest other) {
            this.name(other.getName());
            this.companyName(other.getCompanyName());
            this.companySize(other.getCompanySize());
            this.preferredTools(other.getPreferredTools());
            this.goals(other.getGoals());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CompanySizeStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="company_size")
        public PreferredToolsStage companySize(String companySize) {
            this.companySize = companySize;
            return this;
        }

        @Override
        @JsonSetter(value="preferred_tools")
        public GoalsStage preferredTools(String preferredTools) {
            this.preferredTools = preferredTools;
            return this;
        }

        @Override
        @JsonSetter(value="goals")
        public _FinalStage goals(String goals) {
            this.goals = goals;
            return this;
        }

        @Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.of(companyName);
            return this;
        }

        @Override
        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @Override
        public SignupForBetaRequest build() {
            return new SignupForBetaRequest(this.name, this.companyName, this.companySize, this.preferredTools, this.goals);
        }
    }

    public static interface _FinalStage {
        public SignupForBetaRequest build();

        public _FinalStage companyName(Optional<String> var1);

        public _FinalStage companyName(String var1);
    }

    public static interface GoalsStage {
        public _FinalStage goals(String var1);
    }

    public static interface PreferredToolsStage {
        public GoalsStage preferredTools(String var1);
    }

    public static interface CompanySizeStage {
        public PreferredToolsStage companySize(String var1);
    }

    public static interface NameStage {
        public CompanySizeStage name(String var1);

        public Builder from(SignupForBetaRequest var1);
    }
}

