/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ReportRequest {
    private final Optional<String> reason;

    private ReportRequest(Optional<String> reason) {
        this.reason = reason;
    }

    @JsonProperty(value="reason")
    public Optional<String> getReason() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ReportRequest && this.equalTo((ReportRequest)other);
    }

    private boolean equalTo(ReportRequest other) {
        return this.reason.equals(other.reason);
    }

    public int hashCode() {
        return Objects.hash(this.reason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> reason = Optional.empty();

        private Builder() {
        }

        public Builder from(ReportRequest other) {
            this.reason(other.getReason());
            return this;
        }

        @JsonSetter(value="reason", nulls=Nulls.SKIP)
        public Builder reason(Optional<String> reason) {
            this.reason = reason;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = Optional.of(reason);
            return this;
        }

        public ReportRequest build() {
            return new ReportRequest(this.reason);
        }
    }
}

