/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.links.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetGameLinkRequest {
    private final String identityLinkToken;
    private final Optional<String> watchIndex;

    private GetGameLinkRequest(String identityLinkToken, Optional<String> watchIndex) {
        this.identityLinkToken = identityLinkToken;
        this.watchIndex = watchIndex;
    }

    @JsonProperty(value="identity_link_token")
    public String getIdentityLinkToken() {
        return this.identityLinkToken;
    }

    @JsonProperty(value="watch_index")
    public Optional<String> getWatchIndex() {
        return this.watchIndex;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetGameLinkRequest && this.equalTo((GetGameLinkRequest)other);
    }

    private boolean equalTo(GetGameLinkRequest other) {
        return this.identityLinkToken.equals(other.identityLinkToken) && this.watchIndex.equals(other.watchIndex);
    }

    public int hashCode() {
        return Objects.hash(this.identityLinkToken, this.watchIndex);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityLinkTokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityLinkTokenStage,
    _FinalStage {
        private String identityLinkToken;
        private Optional<String> watchIndex = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetGameLinkRequest other) {
            this.identityLinkToken(other.getIdentityLinkToken());
            this.watchIndex(other.getWatchIndex());
            return this;
        }

        @Override
        @JsonSetter(value="identity_link_token")
        public _FinalStage identityLinkToken(String identityLinkToken) {
            this.identityLinkToken = identityLinkToken;
            return this;
        }

        @Override
        public _FinalStage watchIndex(String watchIndex) {
            this.watchIndex = Optional.of(watchIndex);
            return this;
        }

        @Override
        @JsonSetter(value="watch_index", nulls=Nulls.SKIP)
        public _FinalStage watchIndex(Optional<String> watchIndex) {
            this.watchIndex = watchIndex;
            return this;
        }

        @Override
        public GetGameLinkRequest build() {
            return new GetGameLinkRequest(this.identityLinkToken, this.watchIndex);
        }
    }

    public static interface _FinalStage {
        public GetGameLinkRequest build();

        public _FinalStage watchIndex(Optional<String> var1);

        public _FinalStage watchIndex(String var1);
    }

    public static interface IdentityLinkTokenStage {
        public _FinalStage identityLinkToken(String var1);

        public Builder from(GetGameLinkRequest var1);
    }
}

