/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.ExternalLinks;
import com.rivet.api.resources.identity.common.types.Presence;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Summary {
    private final UUID identityId;
    private final String displayName;
    private final int accountNumber;
    private final String avatarUrl;
    private final Optional<Presence> presence;
    private final boolean isRegistered;
    private final ExternalLinks external;
    private final boolean following;
    private final boolean isFollowingMe;
    private final boolean isMutualFollowing;

    private Summary(UUID identityId, String displayName, int accountNumber, String avatarUrl, Optional<Presence> presence, boolean isRegistered, ExternalLinks external, boolean following, boolean isFollowingMe, boolean isMutualFollowing) {
        this.identityId = identityId;
        this.displayName = displayName;
        this.accountNumber = accountNumber;
        this.avatarUrl = avatarUrl;
        this.presence = presence;
        this.isRegistered = isRegistered;
        this.external = external;
        this.following = following;
        this.isFollowingMe = isFollowingMe;
        this.isMutualFollowing = isMutualFollowing;
    }

    @JsonProperty(value="identity_id")
    public UUID getIdentityId() {
        return this.identityId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="account_number")
    public int getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="avatar_url")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="presence")
    public Optional<Presence> getPresence() {
        return this.presence;
    }

    @JsonProperty(value="is_registered")
    public boolean getIsRegistered() {
        return this.isRegistered;
    }

    @JsonProperty(value="external")
    public ExternalLinks getExternal() {
        return this.external;
    }

    @JsonProperty(value="following")
    public boolean getFollowing() {
        return this.following;
    }

    @JsonProperty(value="is_following_me")
    public boolean getIsFollowingMe() {
        return this.isFollowingMe;
    }

    @JsonProperty(value="is_mutual_following")
    public boolean getIsMutualFollowing() {
        return this.isMutualFollowing;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Summary && this.equalTo((Summary)other);
    }

    private boolean equalTo(Summary other) {
        return this.identityId.equals(other.identityId) && this.displayName.equals(other.displayName) && this.accountNumber == other.accountNumber && this.avatarUrl.equals(other.avatarUrl) && this.presence.equals(other.presence) && this.isRegistered == other.isRegistered && this.external.equals(other.external) && this.following == other.following && this.isFollowingMe == other.isFollowingMe && this.isMutualFollowing == other.isMutualFollowing;
    }

    public int hashCode() {
        return Objects.hash(this.identityId, this.displayName, this.accountNumber, this.avatarUrl, this.presence, this.isRegistered, this.external, this.following, this.isFollowingMe, this.isMutualFollowing);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityIdStage,
    DisplayNameStage,
    AccountNumberStage,
    AvatarUrlStage,
    IsRegisteredStage,
    ExternalStage,
    FollowingStage,
    IsFollowingMeStage,
    IsMutualFollowingStage,
    _FinalStage {
        private UUID identityId;
        private String displayName;
        private int accountNumber;
        private String avatarUrl;
        private boolean isRegistered;
        private ExternalLinks external;
        private boolean following;
        private boolean isFollowingMe;
        private boolean isMutualFollowing;
        private Optional<Presence> presence = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Summary other) {
            this.identityId(other.getIdentityId());
            this.displayName(other.getDisplayName());
            this.accountNumber(other.getAccountNumber());
            this.avatarUrl(other.getAvatarUrl());
            this.presence(other.getPresence());
            this.isRegistered(other.getIsRegistered());
            this.external(other.getExternal());
            this.following(other.getFollowing());
            this.isFollowingMe(other.getIsFollowingMe());
            this.isMutualFollowing(other.getIsMutualFollowing());
            return this;
        }

        @Override
        @JsonSetter(value="identity_id")
        public DisplayNameStage identityId(UUID identityId) {
            this.identityId = identityId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public AccountNumberStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="account_number")
        public AvatarUrlStage accountNumber(int accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Override
        @JsonSetter(value="avatar_url")
        public IsRegisteredStage avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @Override
        @JsonSetter(value="is_registered")
        public ExternalStage isRegistered(boolean isRegistered) {
            this.isRegistered = isRegistered;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public FollowingStage external(ExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        @JsonSetter(value="following")
        public IsFollowingMeStage following(boolean following) {
            this.following = following;
            return this;
        }

        @Override
        @JsonSetter(value="is_following_me")
        public IsMutualFollowingStage isFollowingMe(boolean isFollowingMe) {
            this.isFollowingMe = isFollowingMe;
            return this;
        }

        @Override
        @JsonSetter(value="is_mutual_following")
        public _FinalStage isMutualFollowing(boolean isMutualFollowing) {
            this.isMutualFollowing = isMutualFollowing;
            return this;
        }

        @Override
        public _FinalStage presence(Presence presence) {
            this.presence = Optional.of(presence);
            return this;
        }

        @Override
        @JsonSetter(value="presence", nulls=Nulls.SKIP)
        public _FinalStage presence(Optional<Presence> presence) {
            this.presence = presence;
            return this;
        }

        @Override
        public Summary build() {
            return new Summary(this.identityId, this.displayName, this.accountNumber, this.avatarUrl, this.presence, this.isRegistered, this.external, this.following, this.isFollowingMe, this.isMutualFollowing);
        }
    }

    public static interface _FinalStage {
        public Summary build();

        public _FinalStage presence(Optional<Presence> var1);

        public _FinalStage presence(Presence var1);
    }

    public static interface IsMutualFollowingStage {
        public _FinalStage isMutualFollowing(boolean var1);
    }

    public static interface IsFollowingMeStage {
        public IsMutualFollowingStage isFollowingMe(boolean var1);
    }

    public static interface FollowingStage {
        public IsFollowingMeStage following(boolean var1);
    }

    public static interface ExternalStage {
        public FollowingStage external(ExternalLinks var1);
    }

    public static interface IsRegisteredStage {
        public ExternalStage isRegistered(boolean var1);
    }

    public static interface AvatarUrlStage {
        public IsRegisteredStage avatarUrl(String var1);
    }

    public static interface AccountNumberStage {
        public AvatarUrlStage accountNumber(int var1);
    }

    public static interface DisplayNameStage {
        public AccountNumberStage displayName(String var1);
    }

    public static interface IdentityIdStage {
        public DisplayNameStage identityId(UUID var1);

        public Builder from(Summary var1);
    }
}

