/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.GameActivity;
import com.rivet.api.resources.identity.common.types.Status;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Presence {
    private final OffsetDateTime updateTs;
    private final Status status;
    private final Optional<GameActivity> gameActivity;

    private Presence(OffsetDateTime updateTs, Status status, Optional<GameActivity> gameActivity) {
        this.updateTs = updateTs;
        this.status = status;
        this.gameActivity = gameActivity;
    }

    @JsonProperty(value="update_ts")
    public OffsetDateTime getUpdateTs() {
        return this.updateTs;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="game_activity")
    public Optional<GameActivity> getGameActivity() {
        return this.gameActivity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Presence && this.equalTo((Presence)other);
    }

    private boolean equalTo(Presence other) {
        return this.updateTs.equals(other.updateTs) && this.status.equals((Object)other.status) && this.gameActivity.equals(other.gameActivity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.updateTs, this.status, this.gameActivity});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UpdateTsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UpdateTsStage,
    StatusStage,
    _FinalStage {
        private OffsetDateTime updateTs;
        private Status status;
        private Optional<GameActivity> gameActivity = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Presence other) {
            this.updateTs(other.getUpdateTs());
            this.status(other.getStatus());
            this.gameActivity(other.getGameActivity());
            return this;
        }

        @Override
        @JsonSetter(value="update_ts")
        public StatusStage updateTs(OffsetDateTime updateTs) {
            this.updateTs = updateTs;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(Status status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage gameActivity(GameActivity gameActivity) {
            this.gameActivity = Optional.of(gameActivity);
            return this;
        }

        @Override
        @JsonSetter(value="game_activity", nulls=Nulls.SKIP)
        public _FinalStage gameActivity(Optional<GameActivity> gameActivity) {
            this.gameActivity = gameActivity;
            return this;
        }

        @Override
        public Presence build() {
            return new Presence(this.updateTs, this.status, this.gameActivity);
        }
    }

    public static interface _FinalStage {
        public Presence build();

        public _FinalStage gameActivity(Optional<GameActivity> var1);

        public _FinalStage gameActivity(GameActivity var1);
    }

    public static interface StatusStage {
        public _FinalStage status(Status var1);
    }

    public static interface UpdateTsStage {
        public StatusStage updateTs(OffsetDateTime var1);

        public Builder from(Presence var1);
    }
}

