/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.AccessTokenLinkedAccount;
import com.rivet.api.resources.identity.common.types.EmailLinkedAccount;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LinkedAccount {
    private final Optional<EmailLinkedAccount> email;
    private final Optional<AccessTokenLinkedAccount> accessToken;

    private LinkedAccount(Optional<EmailLinkedAccount> email, Optional<AccessTokenLinkedAccount> accessToken) {
        this.email = email;
        this.accessToken = accessToken;
    }

    @JsonProperty(value="email")
    public Optional<EmailLinkedAccount> getEmail() {
        return this.email;
    }

    @JsonProperty(value="access_token")
    public Optional<AccessTokenLinkedAccount> getAccessToken() {
        return this.accessToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkedAccount && this.equalTo((LinkedAccount)other);
    }

    private boolean equalTo(LinkedAccount other) {
        return this.email.equals(other.email) && this.accessToken.equals(other.accessToken);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.accessToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<EmailLinkedAccount> email = Optional.empty();
        private Optional<AccessTokenLinkedAccount> accessToken = Optional.empty();

        private Builder() {
        }

        public Builder from(LinkedAccount other) {
            this.email(other.getEmail());
            this.accessToken(other.getAccessToken());
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<EmailLinkedAccount> email) {
            this.email = email;
            return this;
        }

        public Builder email(EmailLinkedAccount email) {
            this.email = Optional.of(email);
            return this;
        }

        @JsonSetter(value="access_token", nulls=Nulls.SKIP)
        public Builder accessToken(Optional<AccessTokenLinkedAccount> accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder accessToken(AccessTokenLinkedAccount accessToken) {
            this.accessToken = Optional.of(accessToken);
            return this;
        }

        public LinkedAccount build() {
            return new LinkedAccount(this.email, this.accessToken);
        }
    }
}

