/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.GlobalEventKind;
import com.rivet.api.resources.identity.common.types.GlobalEventNotification;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GlobalEvent {
    private final OffsetDateTime ts;
    private final GlobalEventKind kind;
    private final Optional<GlobalEventNotification> notification;

    private GlobalEvent(OffsetDateTime ts, GlobalEventKind kind, Optional<GlobalEventNotification> notification) {
        this.ts = ts;
        this.kind = kind;
        this.notification = notification;
    }

    @JsonProperty(value="ts")
    public OffsetDateTime getTs() {
        return this.ts;
    }

    @JsonProperty(value="kind")
    public GlobalEventKind getKind() {
        return this.kind;
    }

    @JsonProperty(value="notification")
    public Optional<GlobalEventNotification> getNotification() {
        return this.notification;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GlobalEvent && this.equalTo((GlobalEvent)other);
    }

    private boolean equalTo(GlobalEvent other) {
        return this.ts.equals(other.ts) && this.kind.equals(other.kind) && this.notification.equals(other.notification);
    }

    public int hashCode() {
        return Objects.hash(this.ts, this.kind, this.notification);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TsStage,
    KindStage,
    _FinalStage {
        private OffsetDateTime ts;
        private GlobalEventKind kind;
        private Optional<GlobalEventNotification> notification = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GlobalEvent other) {
            this.ts(other.getTs());
            this.kind(other.getKind());
            this.notification(other.getNotification());
            return this;
        }

        @Override
        @JsonSetter(value="ts")
        public KindStage ts(OffsetDateTime ts) {
            this.ts = ts;
            return this;
        }

        @Override
        @JsonSetter(value="kind")
        public _FinalStage kind(GlobalEventKind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public _FinalStage notification(GlobalEventNotification notification) {
            this.notification = Optional.of(notification);
            return this;
        }

        @Override
        @JsonSetter(value="notification", nulls=Nulls.SKIP)
        public _FinalStage notification(Optional<GlobalEventNotification> notification) {
            this.notification = notification;
            return this;
        }

        @Override
        public GlobalEvent build() {
            return new GlobalEvent(this.ts, this.kind, this.notification);
        }
    }

    public static interface _FinalStage {
        public GlobalEvent build();

        public _FinalStage notification(Optional<GlobalEventNotification> var1);

        public _FinalStage notification(GlobalEventNotification var1);
    }

    public static interface KindStage {
        public _FinalStage kind(GlobalEventKind var1);
    }

    public static interface TsStage {
        public KindStage ts(OffsetDateTime var1);

        public Builder from(GlobalEvent var1);
    }
}

