/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.group.common.types.JoinRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetJoinRequestsResponse {
    private final List<JoinRequest> joinRequests;
    private final Optional<String> anchor;
    private final WatchResponse watch;

    private GetJoinRequestsResponse(List<JoinRequest> joinRequests, Optional<String> anchor, WatchResponse watch) {
        this.joinRequests = joinRequests;
        this.anchor = anchor;
        this.watch = watch;
    }

    @JsonProperty(value="join_requests")
    public List<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetJoinRequestsResponse && this.equalTo((GetJoinRequestsResponse)other);
    }

    private boolean equalTo(GetJoinRequestsResponse other) {
        return this.joinRequests.equals(other.joinRequests) && this.anchor.equals(other.anchor) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.joinRequests, this.anchor, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private Optional<String> anchor = Optional.empty();
        private List<JoinRequest> joinRequests = new ArrayList<JoinRequest>();

        private Builder() {
        }

        @Override
        public Builder from(GetJoinRequestsResponse other) {
            this.joinRequests(other.getJoinRequests());
            this.anchor(other.getAnchor());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @Override
        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public _FinalStage anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        @Override
        public _FinalStage addAllJoinRequests(List<JoinRequest> joinRequests) {
            this.joinRequests.addAll(joinRequests);
            return this;
        }

        @Override
        public _FinalStage addJoinRequests(JoinRequest joinRequests) {
            this.joinRequests.add(joinRequests);
            return this;
        }

        @Override
        @JsonSetter(value="join_requests", nulls=Nulls.SKIP)
        public _FinalStage joinRequests(List<JoinRequest> joinRequests) {
            this.joinRequests.clear();
            this.joinRequests.addAll(joinRequests);
            return this;
        }

        @Override
        public GetJoinRequestsResponse build() {
            return new GetJoinRequestsResponse(this.joinRequests, this.anchor, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetJoinRequestsResponse build();

        public _FinalStage joinRequests(List<JoinRequest> var1);

        public _FinalStage addJoinRequests(JoinRequest var1);

        public _FinalStage addAllJoinRequests(List<JoinRequest> var1);

        public _FinalStage anchor(Optional<String> var1);

        public _FinalStage anchor(String var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetJoinRequestsResponse var1);
    }
}

