/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.group.common.types.ExternalLinks;
import com.rivet.api.resources.group.common.types.Publicity;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Summary {
    private final UUID groupId;
    private final String displayName;
    private final Optional<String> avatarUrl;
    private final ExternalLinks external;
    private final boolean isDeveloper;
    private final String bio;
    private final boolean isCurrentIdentityMember;
    private final Publicity publicity;
    private final int memberCount;
    private final UUID ownerIdentityId;

    private Summary(UUID groupId, String displayName, Optional<String> avatarUrl, ExternalLinks external, boolean isDeveloper, String bio, boolean isCurrentIdentityMember, Publicity publicity, int memberCount, UUID ownerIdentityId) {
        this.groupId = groupId;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
        this.external = external;
        this.isDeveloper = isDeveloper;
        this.bio = bio;
        this.isCurrentIdentityMember = isCurrentIdentityMember;
        this.publicity = publicity;
        this.memberCount = memberCount;
        this.ownerIdentityId = ownerIdentityId;
    }

    @JsonProperty(value="group_id")
    public UUID getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="avatar_url")
    public Optional<String> getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="external")
    public ExternalLinks getExternal() {
        return this.external;
    }

    @JsonProperty(value="is_developer")
    public boolean getIsDeveloper() {
        return this.isDeveloper;
    }

    @JsonProperty(value="bio")
    public String getBio() {
        return this.bio;
    }

    @JsonProperty(value="is_current_identity_member")
    public boolean getIsCurrentIdentityMember() {
        return this.isCurrentIdentityMember;
    }

    @JsonProperty(value="publicity")
    public Publicity getPublicity() {
        return this.publicity;
    }

    @JsonProperty(value="member_count")
    public int getMemberCount() {
        return this.memberCount;
    }

    @JsonProperty(value="owner_identity_id")
    public UUID getOwnerIdentityId() {
        return this.ownerIdentityId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Summary && this.equalTo((Summary)other);
    }

    private boolean equalTo(Summary other) {
        return this.groupId.equals(other.groupId) && this.displayName.equals(other.displayName) && this.avatarUrl.equals(other.avatarUrl) && this.external.equals(other.external) && this.isDeveloper == other.isDeveloper && this.bio.equals(other.bio) && this.isCurrentIdentityMember == other.isCurrentIdentityMember && this.publicity.equals((Object)other.publicity) && this.memberCount == other.memberCount && this.ownerIdentityId.equals(other.ownerIdentityId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.displayName, this.avatarUrl, this.external, this.isDeveloper, this.bio, this.isCurrentIdentityMember, this.publicity, this.memberCount, this.ownerIdentityId});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GroupIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GroupIdStage,
    DisplayNameStage,
    ExternalStage,
    IsDeveloperStage,
    BioStage,
    IsCurrentIdentityMemberStage,
    PublicityStage,
    MemberCountStage,
    OwnerIdentityIdStage,
    _FinalStage {
        private UUID groupId;
        private String displayName;
        private ExternalLinks external;
        private boolean isDeveloper;
        private String bio;
        private boolean isCurrentIdentityMember;
        private Publicity publicity;
        private int memberCount;
        private UUID ownerIdentityId;
        private Optional<String> avatarUrl = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Summary other) {
            this.groupId(other.getGroupId());
            this.displayName(other.getDisplayName());
            this.avatarUrl(other.getAvatarUrl());
            this.external(other.getExternal());
            this.isDeveloper(other.getIsDeveloper());
            this.bio(other.getBio());
            this.isCurrentIdentityMember(other.getIsCurrentIdentityMember());
            this.publicity(other.getPublicity());
            this.memberCount(other.getMemberCount());
            this.ownerIdentityId(other.getOwnerIdentityId());
            return this;
        }

        @Override
        @JsonSetter(value="group_id")
        public DisplayNameStage groupId(UUID groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public ExternalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public IsDeveloperStage external(ExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        @JsonSetter(value="is_developer")
        public BioStage isDeveloper(boolean isDeveloper) {
            this.isDeveloper = isDeveloper;
            return this;
        }

        @Override
        @JsonSetter(value="bio")
        public IsCurrentIdentityMemberStage bio(String bio) {
            this.bio = bio;
            return this;
        }

        @Override
        @JsonSetter(value="is_current_identity_member")
        public PublicityStage isCurrentIdentityMember(boolean isCurrentIdentityMember) {
            this.isCurrentIdentityMember = isCurrentIdentityMember;
            return this;
        }

        @Override
        @JsonSetter(value="publicity")
        public MemberCountStage publicity(Publicity publicity) {
            this.publicity = publicity;
            return this;
        }

        @Override
        @JsonSetter(value="member_count")
        public OwnerIdentityIdStage memberCount(int memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        @Override
        @JsonSetter(value="owner_identity_id")
        public _FinalStage ownerIdentityId(UUID ownerIdentityId) {
            this.ownerIdentityId = ownerIdentityId;
            return this;
        }

        @Override
        public _FinalStage avatarUrl(String avatarUrl) {
            this.avatarUrl = Optional.of(avatarUrl);
            return this;
        }

        @Override
        @JsonSetter(value="avatar_url", nulls=Nulls.SKIP)
        public _FinalStage avatarUrl(Optional<String> avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @Override
        public Summary build() {
            return new Summary(this.groupId, this.displayName, this.avatarUrl, this.external, this.isDeveloper, this.bio, this.isCurrentIdentityMember, this.publicity, this.memberCount, this.ownerIdentityId);
        }
    }

    public static interface _FinalStage {
        public Summary build();

        public _FinalStage avatarUrl(Optional<String> var1);

        public _FinalStage avatarUrl(String var1);
    }

    public static interface OwnerIdentityIdStage {
        public _FinalStage ownerIdentityId(UUID var1);
    }

    public static interface MemberCountStage {
        public OwnerIdentityIdStage memberCount(int var1);
    }

    public static interface PublicityStage {
        public MemberCountStage publicity(Publicity var1);
    }

    public static interface IsCurrentIdentityMemberStage {
        public PublicityStage isCurrentIdentityMember(boolean var1);
    }

    public static interface BioStage {
        public IsCurrentIdentityMemberStage bio(String var1);
    }

    public static interface IsDeveloperStage {
        public BioStage isDeveloper(boolean var1);
    }

    public static interface ExternalStage {
        public IsDeveloperStage external(ExternalLinks var1);
    }

    public static interface DisplayNameStage {
        public ExternalStage displayName(String var1);
    }

    public static interface GroupIdStage {
        public DisplayNameStage groupId(UUID var1);

        public Builder from(Summary var1);
    }
}

