/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.group.common.types.ExternalLinks;
import com.rivet.api.resources.group.common.types.JoinRequest;
import com.rivet.api.resources.group.common.types.Member;
import com.rivet.api.resources.group.common.types.Publicity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Profile {
    private final UUID groupId;
    private final String displayName;
    private final Optional<String> avatarUrl;
    private final ExternalLinks external;
    private final Optional<Boolean> isDeveloper;
    private final String bio;
    private final Optional<Boolean> isCurrentIdentityMember;
    private final Publicity publicity;
    private final Optional<Integer> memberCount;
    private final List<Member> members;
    private final List<JoinRequest> joinRequests;
    private final Optional<Boolean> isCurrentIdentityRequestingJoin;
    private final UUID ownerIdentityId;

    private Profile(UUID groupId, String displayName, Optional<String> avatarUrl, ExternalLinks external, Optional<Boolean> isDeveloper, String bio, Optional<Boolean> isCurrentIdentityMember, Publicity publicity, Optional<Integer> memberCount, List<Member> members, List<JoinRequest> joinRequests, Optional<Boolean> isCurrentIdentityRequestingJoin, UUID ownerIdentityId) {
        this.groupId = groupId;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
        this.external = external;
        this.isDeveloper = isDeveloper;
        this.bio = bio;
        this.isCurrentIdentityMember = isCurrentIdentityMember;
        this.publicity = publicity;
        this.memberCount = memberCount;
        this.members = members;
        this.joinRequests = joinRequests;
        this.isCurrentIdentityRequestingJoin = isCurrentIdentityRequestingJoin;
        this.ownerIdentityId = ownerIdentityId;
    }

    @JsonProperty(value="group_id")
    public UUID getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="avatar_url")
    public Optional<String> getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="external")
    public ExternalLinks getExternal() {
        return this.external;
    }

    @JsonProperty(value="is_developer")
    public Optional<Boolean> getIsDeveloper() {
        return this.isDeveloper;
    }

    @JsonProperty(value="bio")
    public String getBio() {
        return this.bio;
    }

    @JsonProperty(value="is_current_identity_member")
    public Optional<Boolean> getIsCurrentIdentityMember() {
        return this.isCurrentIdentityMember;
    }

    @JsonProperty(value="publicity")
    public Publicity getPublicity() {
        return this.publicity;
    }

    @JsonProperty(value="member_count")
    public Optional<Integer> getMemberCount() {
        return this.memberCount;
    }

    @JsonProperty(value="members")
    public List<Member> getMembers() {
        return this.members;
    }

    @JsonProperty(value="join_requests")
    public List<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    @JsonProperty(value="is_current_identity_requesting_join")
    public Optional<Boolean> getIsCurrentIdentityRequestingJoin() {
        return this.isCurrentIdentityRequestingJoin;
    }

    @JsonProperty(value="owner_identity_id")
    public UUID getOwnerIdentityId() {
        return this.ownerIdentityId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Profile && this.equalTo((Profile)other);
    }

    private boolean equalTo(Profile other) {
        return this.groupId.equals(other.groupId) && this.displayName.equals(other.displayName) && this.avatarUrl.equals(other.avatarUrl) && this.external.equals(other.external) && this.isDeveloper.equals(other.isDeveloper) && this.bio.equals(other.bio) && this.isCurrentIdentityMember.equals(other.isCurrentIdentityMember) && this.publicity.equals((Object)other.publicity) && this.memberCount.equals(other.memberCount) && this.members.equals(other.members) && this.joinRequests.equals(other.joinRequests) && this.isCurrentIdentityRequestingJoin.equals(other.isCurrentIdentityRequestingJoin) && this.ownerIdentityId.equals(other.ownerIdentityId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.displayName, this.avatarUrl, this.external, this.isDeveloper, this.bio, this.isCurrentIdentityMember, this.publicity, this.memberCount, this.members, this.joinRequests, this.isCurrentIdentityRequestingJoin, this.ownerIdentityId});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GroupIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GroupIdStage,
    DisplayNameStage,
    ExternalStage,
    BioStage,
    PublicityStage,
    OwnerIdentityIdStage,
    _FinalStage {
        private UUID groupId;
        private String displayName;
        private ExternalLinks external;
        private String bio;
        private Publicity publicity;
        private UUID ownerIdentityId;
        private Optional<Boolean> isCurrentIdentityRequestingJoin = Optional.empty();
        private List<JoinRequest> joinRequests = new ArrayList<JoinRequest>();
        private List<Member> members = new ArrayList<Member>();
        private Optional<Integer> memberCount = Optional.empty();
        private Optional<Boolean> isCurrentIdentityMember = Optional.empty();
        private Optional<Boolean> isDeveloper = Optional.empty();
        private Optional<String> avatarUrl = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Profile other) {
            this.groupId(other.getGroupId());
            this.displayName(other.getDisplayName());
            this.avatarUrl(other.getAvatarUrl());
            this.external(other.getExternal());
            this.isDeveloper(other.getIsDeveloper());
            this.bio(other.getBio());
            this.isCurrentIdentityMember(other.getIsCurrentIdentityMember());
            this.publicity(other.getPublicity());
            this.memberCount(other.getMemberCount());
            this.members(other.getMembers());
            this.joinRequests(other.getJoinRequests());
            this.isCurrentIdentityRequestingJoin(other.getIsCurrentIdentityRequestingJoin());
            this.ownerIdentityId(other.getOwnerIdentityId());
            return this;
        }

        @Override
        @JsonSetter(value="group_id")
        public DisplayNameStage groupId(UUID groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public ExternalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public BioStage external(ExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        @JsonSetter(value="bio")
        public PublicityStage bio(String bio) {
            this.bio = bio;
            return this;
        }

        @Override
        @JsonSetter(value="publicity")
        public OwnerIdentityIdStage publicity(Publicity publicity) {
            this.publicity = publicity;
            return this;
        }

        @Override
        @JsonSetter(value="owner_identity_id")
        public _FinalStage ownerIdentityId(UUID ownerIdentityId) {
            this.ownerIdentityId = ownerIdentityId;
            return this;
        }

        @Override
        public _FinalStage isCurrentIdentityRequestingJoin(Boolean isCurrentIdentityRequestingJoin) {
            this.isCurrentIdentityRequestingJoin = Optional.of(isCurrentIdentityRequestingJoin);
            return this;
        }

        @Override
        @JsonSetter(value="is_current_identity_requesting_join", nulls=Nulls.SKIP)
        public _FinalStage isCurrentIdentityRequestingJoin(Optional<Boolean> isCurrentIdentityRequestingJoin) {
            this.isCurrentIdentityRequestingJoin = isCurrentIdentityRequestingJoin;
            return this;
        }

        @Override
        public _FinalStage addAllJoinRequests(List<JoinRequest> joinRequests) {
            this.joinRequests.addAll(joinRequests);
            return this;
        }

        @Override
        public _FinalStage addJoinRequests(JoinRequest joinRequests) {
            this.joinRequests.add(joinRequests);
            return this;
        }

        @Override
        @JsonSetter(value="join_requests", nulls=Nulls.SKIP)
        public _FinalStage joinRequests(List<JoinRequest> joinRequests) {
            this.joinRequests.clear();
            this.joinRequests.addAll(joinRequests);
            return this;
        }

        @Override
        public _FinalStage addAllMembers(List<Member> members) {
            this.members.addAll(members);
            return this;
        }

        @Override
        public _FinalStage addMembers(Member members) {
            this.members.add(members);
            return this;
        }

        @Override
        @JsonSetter(value="members", nulls=Nulls.SKIP)
        public _FinalStage members(List<Member> members) {
            this.members.clear();
            this.members.addAll(members);
            return this;
        }

        @Override
        public _FinalStage memberCount(Integer memberCount) {
            this.memberCount = Optional.of(memberCount);
            return this;
        }

        @Override
        @JsonSetter(value="member_count", nulls=Nulls.SKIP)
        public _FinalStage memberCount(Optional<Integer> memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        @Override
        public _FinalStage isCurrentIdentityMember(Boolean isCurrentIdentityMember) {
            this.isCurrentIdentityMember = Optional.of(isCurrentIdentityMember);
            return this;
        }

        @Override
        @JsonSetter(value="is_current_identity_member", nulls=Nulls.SKIP)
        public _FinalStage isCurrentIdentityMember(Optional<Boolean> isCurrentIdentityMember) {
            this.isCurrentIdentityMember = isCurrentIdentityMember;
            return this;
        }

        @Override
        public _FinalStage isDeveloper(Boolean isDeveloper) {
            this.isDeveloper = Optional.of(isDeveloper);
            return this;
        }

        @Override
        @JsonSetter(value="is_developer", nulls=Nulls.SKIP)
        public _FinalStage isDeveloper(Optional<Boolean> isDeveloper) {
            this.isDeveloper = isDeveloper;
            return this;
        }

        @Override
        public _FinalStage avatarUrl(String avatarUrl) {
            this.avatarUrl = Optional.of(avatarUrl);
            return this;
        }

        @Override
        @JsonSetter(value="avatar_url", nulls=Nulls.SKIP)
        public _FinalStage avatarUrl(Optional<String> avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @Override
        public Profile build() {
            return new Profile(this.groupId, this.displayName, this.avatarUrl, this.external, this.isDeveloper, this.bio, this.isCurrentIdentityMember, this.publicity, this.memberCount, this.members, this.joinRequests, this.isCurrentIdentityRequestingJoin, this.ownerIdentityId);
        }
    }

    public static interface _FinalStage {
        public Profile build();

        public _FinalStage avatarUrl(Optional<String> var1);

        public _FinalStage avatarUrl(String var1);

        public _FinalStage isDeveloper(Optional<Boolean> var1);

        public _FinalStage isDeveloper(Boolean var1);

        public _FinalStage isCurrentIdentityMember(Optional<Boolean> var1);

        public _FinalStage isCurrentIdentityMember(Boolean var1);

        public _FinalStage memberCount(Optional<Integer> var1);

        public _FinalStage memberCount(Integer var1);

        public _FinalStage members(List<Member> var1);

        public _FinalStage addMembers(Member var1);

        public _FinalStage addAllMembers(List<Member> var1);

        public _FinalStage joinRequests(List<JoinRequest> var1);

        public _FinalStage addJoinRequests(JoinRequest var1);

        public _FinalStage addAllJoinRequests(List<JoinRequest> var1);

        public _FinalStage isCurrentIdentityRequestingJoin(Optional<Boolean> var1);

        public _FinalStage isCurrentIdentityRequestingJoin(Boolean var1);
    }

    public static interface OwnerIdentityIdStage {
        public _FinalStage ownerIdentityId(UUID var1);
    }

    public static interface PublicityStage {
        public OwnerIdentityIdStage publicity(Publicity var1);
    }

    public static interface BioStage {
        public PublicityStage bio(String var1);
    }

    public static interface ExternalStage {
        public BioStage external(ExternalLinks var1);
    }

    public static interface DisplayNameStage {
        public ExternalStage displayName(String var1);
    }

    public static interface GroupIdStage {
        public DisplayNameStage groupId(UUID var1);

        public Builder from(Profile var1);
    }
}

