/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.Handle;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JoinRequest {
    private final Handle identity;
    private final OffsetDateTime ts;

    private JoinRequest(Handle identity, OffsetDateTime ts) {
        this.identity = identity;
        this.ts = ts;
    }

    @JsonProperty(value="identity")
    public Handle getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="ts")
    public OffsetDateTime getTs() {
        return this.ts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JoinRequest && this.equalTo((JoinRequest)other);
    }

    private boolean equalTo(JoinRequest other) {
        return this.identity.equals(other.identity) && this.ts.equals(other.ts);
    }

    public int hashCode() {
        return Objects.hash(this.identity, this.ts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityStage,
    TsStage,
    _FinalStage {
        private Handle identity;
        private OffsetDateTime ts;

        private Builder() {
        }

        @Override
        public Builder from(JoinRequest other) {
            this.identity(other.getIdentity());
            this.ts(other.getTs());
            return this;
        }

        @Override
        @JsonSetter(value="identity")
        public TsStage identity(Handle identity) {
            this.identity = identity;
            return this;
        }

        @Override
        @JsonSetter(value="ts")
        public _FinalStage ts(OffsetDateTime ts) {
            this.ts = ts;
            return this;
        }

        @Override
        public JoinRequest build() {
            return new JoinRequest(this.identity, this.ts);
        }
    }

    public static interface _FinalStage {
        public JoinRequest build();
    }

    public static interface TsStage {
        public _FinalStage ts(OffsetDateTime var1);
    }

    public static interface IdentityStage {
        public TsStage identity(Handle var1);

        public Builder from(JoinRequest var1);
    }
}

