/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.geo.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Coord {
    private final double latitude;
    private final double longitude;

    private Coord(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @JsonProperty(value="latitude")
    public double getLatitude() {
        return this.latitude;
    }

    @JsonProperty(value="longitude")
    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Coord && this.equalTo((Coord)other);
    }

    private boolean equalTo(Coord other) {
        return this.latitude == other.latitude && this.longitude == other.longitude;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LatitudeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LatitudeStage,
    LongitudeStage,
    _FinalStage {
        private double latitude;
        private double longitude;

        private Builder() {
        }

        @Override
        public Builder from(Coord other) {
            this.latitude(other.getLatitude());
            this.longitude(other.getLongitude());
            return this;
        }

        @Override
        @JsonSetter(value="latitude")
        public LongitudeStage latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        @Override
        @JsonSetter(value="longitude")
        public _FinalStage longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public Coord build() {
            return new Coord(this.latitude, this.longitude);
        }
    }

    public static interface _FinalStage {
        public Coord build();
    }

    public static interface LongitudeStage {
        public _FinalStage longitude(double var1);
    }

    public static interface LatitudeStage {
        public LongitudeStage latitude(double var1);

        public Builder from(Coord var1);
    }
}

