/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.game.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.group.common.types.Handle;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Summary {
    private final UUID gameId;
    private final String nameId;
    private final String displayName;
    private final Optional<String> logoUrl;
    private final Optional<String> bannerUrl;
    private final String url;
    private final Handle developer;
    private final int totalPlayerCount;

    private Summary(UUID gameId, String nameId, String displayName, Optional<String> logoUrl, Optional<String> bannerUrl, String url, Handle developer, int totalPlayerCount) {
        this.gameId = gameId;
        this.nameId = nameId;
        this.displayName = displayName;
        this.logoUrl = logoUrl;
        this.bannerUrl = bannerUrl;
        this.url = url;
        this.developer = developer;
        this.totalPlayerCount = totalPlayerCount;
    }

    @JsonProperty(value="game_id")
    public UUID getGameId() {
        return this.gameId;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="banner_url")
    public Optional<String> getBannerUrl() {
        return this.bannerUrl;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="developer")
    public Handle getDeveloper() {
        return this.developer;
    }

    @JsonProperty(value="total_player_count")
    public int getTotalPlayerCount() {
        return this.totalPlayerCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Summary && this.equalTo((Summary)other);
    }

    private boolean equalTo(Summary other) {
        return this.gameId.equals(other.gameId) && this.nameId.equals(other.nameId) && this.displayName.equals(other.displayName) && this.logoUrl.equals(other.logoUrl) && this.bannerUrl.equals(other.bannerUrl) && this.url.equals(other.url) && this.developer.equals(other.developer) && this.totalPlayerCount == other.totalPlayerCount;
    }

    public int hashCode() {
        return Objects.hash(this.gameId, this.nameId, this.displayName, this.logoUrl, this.bannerUrl, this.url, this.developer, this.totalPlayerCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameIdStage,
    NameIdStage,
    DisplayNameStage,
    UrlStage,
    DeveloperStage,
    TotalPlayerCountStage,
    _FinalStage {
        private UUID gameId;
        private String nameId;
        private String displayName;
        private String url;
        private Handle developer;
        private int totalPlayerCount;
        private Optional<String> bannerUrl = Optional.empty();
        private Optional<String> logoUrl = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Summary other) {
            this.gameId(other.getGameId());
            this.nameId(other.getNameId());
            this.displayName(other.getDisplayName());
            this.logoUrl(other.getLogoUrl());
            this.bannerUrl(other.getBannerUrl());
            this.url(other.getUrl());
            this.developer(other.getDeveloper());
            this.totalPlayerCount(other.getTotalPlayerCount());
            return this;
        }

        @Override
        @JsonSetter(value="game_id")
        public NameIdStage gameId(UUID gameId) {
            this.gameId = gameId;
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public DisplayNameStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public UrlStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public DeveloperStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @JsonSetter(value="developer")
        public TotalPlayerCountStage developer(Handle developer) {
            this.developer = developer;
            return this;
        }

        @Override
        @JsonSetter(value="total_player_count")
        public _FinalStage totalPlayerCount(int totalPlayerCount) {
            this.totalPlayerCount = totalPlayerCount;
            return this;
        }

        @Override
        public _FinalStage bannerUrl(String bannerUrl) {
            this.bannerUrl = Optional.of(bannerUrl);
            return this;
        }

        @Override
        @JsonSetter(value="banner_url", nulls=Nulls.SKIP)
        public _FinalStage bannerUrl(Optional<String> bannerUrl) {
            this.bannerUrl = bannerUrl;
            return this;
        }

        @Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.of(logoUrl);
            return this;
        }

        @Override
        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public Summary build() {
            return new Summary(this.gameId, this.nameId, this.displayName, this.logoUrl, this.bannerUrl, this.url, this.developer, this.totalPlayerCount);
        }
    }

    public static interface _FinalStage {
        public Summary build();

        public _FinalStage logoUrl(Optional<String> var1);

        public _FinalStage logoUrl(String var1);

        public _FinalStage bannerUrl(Optional<String> var1);

        public _FinalStage bannerUrl(String var1);
    }

    public static interface TotalPlayerCountStage {
        public _FinalStage totalPlayerCount(int var1);
    }

    public static interface DeveloperStage {
        public TotalPlayerCountStage developer(Handle var1);
    }

    public static interface UrlStage {
        public DeveloperStage url(String var1);
    }

    public static interface DisplayNameStage {
        public UrlStage displayName(String var1);
    }

    public static interface NameIdStage {
        public DisplayNameStage nameId(String var1);
    }

    public static interface GameIdStage {
        public NameIdStage gameId(UUID var1);

        public Builder from(Summary var1);
    }
}

