/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.game.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.game.common.types.Handle;
import com.rivet.api.resources.game.common.types.Stat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class StatSummary {
    private final Handle game;
    private final List<Stat> stats;

    private StatSummary(Handle game, List<Stat> stats) {
        this.game = game;
        this.stats = stats;
    }

    @JsonProperty(value="game")
    public Handle getGame() {
        return this.game;
    }

    @JsonProperty(value="stats")
    public List<Stat> getStats() {
        return this.stats;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StatSummary && this.equalTo((StatSummary)other);
    }

    private boolean equalTo(StatSummary other) {
        return this.game.equals(other.game) && this.stats.equals(other.stats);
    }

    public int hashCode() {
        return Objects.hash(this.game, this.stats);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameStage,
    _FinalStage {
        private Handle game;
        private List<Stat> stats = new ArrayList<Stat>();

        private Builder() {
        }

        @Override
        public Builder from(StatSummary other) {
            this.game(other.getGame());
            this.stats(other.getStats());
            return this;
        }

        @Override
        @JsonSetter(value="game")
        public _FinalStage game(Handle game) {
            this.game = game;
            return this;
        }

        @Override
        public _FinalStage addAllStats(List<Stat> stats) {
            this.stats.addAll(stats);
            return this;
        }

        @Override
        public _FinalStage addStats(Stat stats) {
            this.stats.add(stats);
            return this;
        }

        @Override
        @JsonSetter(value="stats", nulls=Nulls.SKIP)
        public _FinalStage stats(List<Stat> stats) {
            this.stats.clear();
            this.stats.addAll(stats);
            return this;
        }

        @Override
        public StatSummary build() {
            return new StatSummary(this.game, this.stats);
        }
    }

    public static interface _FinalStage {
        public StatSummary build();

        public _FinalStage stats(List<Stat> var1);

        public _FinalStage addStats(Stat var1);

        public _FinalStage addAllStats(List<Stat> var1);
    }

    public static interface GameStage {
        public _FinalStage game(Handle var1);

        public Builder from(StatSummary var1);
    }
}

