/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ErrorBody {
    private final String code;
    private final String message;
    private final Optional<String> documentation;
    private final Optional<Object> metadata;

    private ErrorBody(String code, String message, Optional<String> documentation, Optional<Object> metadata) {
        this.code = code;
        this.message = message;
        this.documentation = documentation;
        this.metadata = metadata;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="documentation")
    public Optional<String> getDocumentation() {
        return this.documentation;
    }

    @JsonProperty(value="metadata")
    public Optional<Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ErrorBody && this.equalTo((ErrorBody)other);
    }

    private boolean equalTo(ErrorBody other) {
        return this.code.equals(other.code) && this.message.equals(other.message) && this.documentation.equals(other.documentation) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.documentation, this.metadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CodeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CodeStage,
    MessageStage,
    _FinalStage {
        private String code;
        private String message;
        private Optional<Object> metadata = Optional.empty();
        private Optional<String> documentation = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ErrorBody other) {
            this.code(other.getCode());
            this.message(other.getMessage());
            this.documentation(other.getDocumentation());
            this.metadata(other.getMetadata());
            return this;
        }

        @Override
        @JsonSetter(value="code")
        public MessageStage code(String code) {
            this.code = code;
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public _FinalStage message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage metadata(Object metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage documentation(String documentation) {
            this.documentation = Optional.of(documentation);
            return this;
        }

        @Override
        @JsonSetter(value="documentation", nulls=Nulls.SKIP)
        public _FinalStage documentation(Optional<String> documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public ErrorBody build() {
            return new ErrorBody(this.code, this.message, this.documentation, this.metadata);
        }
    }

    public static interface _FinalStage {
        public ErrorBody build();

        public _FinalStage documentation(Optional<String> var1);

        public _FinalStage documentation(String var1);

        public _FinalStage metadata(Optional<Object> var1);

        public _FinalStage metadata(Object var1);
    }

    public static interface MessageStage {
        public _FinalStage message(String var1);
    }

    public static interface CodeStage {
        public MessageStage code(String var1);

        public Builder from(ErrorBody var1);
    }
}

