/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.types.Config;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Full {
    private final UUID versionId;
    private final OffsetDateTime createTs;
    private final String displayName;
    private final Config config;

    private Full(UUID versionId, OffsetDateTime createTs, String displayName, Config config) {
        this.versionId = versionId;
        this.createTs = createTs;
        this.displayName = displayName;
        this.config = config;
    }

    @JsonProperty(value="version_id")
    public UUID getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Full && this.equalTo((Full)other);
    }

    private boolean equalTo(Full other) {
        return this.versionId.equals(other.versionId) && this.createTs.equals(other.createTs) && this.displayName.equals(other.displayName) && this.config.equals(other.config);
    }

    public int hashCode() {
        return Objects.hash(this.versionId, this.createTs, this.displayName, this.config);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VersionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VersionIdStage,
    CreateTsStage,
    DisplayNameStage,
    ConfigStage,
    _FinalStage {
        private UUID versionId;
        private OffsetDateTime createTs;
        private String displayName;
        private Config config;

        private Builder() {
        }

        @Override
        public Builder from(Full other) {
            this.versionId(other.getVersionId());
            this.createTs(other.getCreateTs());
            this.displayName(other.getDisplayName());
            this.config(other.getConfig());
            return this;
        }

        @Override
        @JsonSetter(value="version_id")
        public CreateTsStage versionId(UUID versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public DisplayNameStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public ConfigStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="config")
        public _FinalStage config(Config config) {
            this.config = config;
            return this;
        }

        @Override
        public Full build() {
            return new Full(this.versionId, this.createTs, this.displayName, this.config);
        }
    }

    public static interface _FinalStage {
        public Full build();
    }

    public static interface ConfigStage {
        public _FinalStage config(Config var1);
    }

    public static interface DisplayNameStage {
        public ConfigStage displayName(String var1);
    }

    public static interface CreateTsStage {
        public DisplayNameStage createTs(OffsetDateTime var1);
    }

    public static interface VersionIdStage {
        public CreateTsStage versionId(UUID var1);

        public Builder from(Full var1);
    }
}

