/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.gamemode.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeIdentityRequirement;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeVerificationConfig;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeFindConfig {
    private final boolean enabled;
    private final Optional<GameModeIdentityRequirement> identityRequirement;
    private final Optional<GameModeVerificationConfig> verification;

    private GameModeFindConfig(boolean enabled, Optional<GameModeIdentityRequirement> identityRequirement, Optional<GameModeVerificationConfig> verification) {
        this.enabled = enabled;
        this.identityRequirement = identityRequirement;
        this.verification = verification;
    }

    @JsonProperty(value="enabled")
    public boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="identity_requirement")
    public Optional<GameModeIdentityRequirement> getIdentityRequirement() {
        return this.identityRequirement;
    }

    @JsonProperty(value="verification")
    public Optional<GameModeVerificationConfig> getVerification() {
        return this.verification;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeFindConfig && this.equalTo((GameModeFindConfig)other);
    }

    private boolean equalTo(GameModeFindConfig other) {
        return this.enabled == other.enabled && this.identityRequirement.equals(other.identityRequirement) && this.verification.equals(other.verification);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.identityRequirement, this.verification);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EnabledStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EnabledStage,
    _FinalStage {
        private boolean enabled;
        private Optional<GameModeVerificationConfig> verification = Optional.empty();
        private Optional<GameModeIdentityRequirement> identityRequirement = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameModeFindConfig other) {
            this.enabled(other.getEnabled());
            this.identityRequirement(other.getIdentityRequirement());
            this.verification(other.getVerification());
            return this;
        }

        @Override
        @JsonSetter(value="enabled")
        public _FinalStage enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public _FinalStage verification(GameModeVerificationConfig verification) {
            this.verification = Optional.of(verification);
            return this;
        }

        @Override
        @JsonSetter(value="verification", nulls=Nulls.SKIP)
        public _FinalStage verification(Optional<GameModeVerificationConfig> verification) {
            this.verification = verification;
            return this;
        }

        @Override
        public _FinalStage identityRequirement(GameModeIdentityRequirement identityRequirement) {
            this.identityRequirement = Optional.of(identityRequirement);
            return this;
        }

        @Override
        @JsonSetter(value="identity_requirement", nulls=Nulls.SKIP)
        public _FinalStage identityRequirement(Optional<GameModeIdentityRequirement> identityRequirement) {
            this.identityRequirement = identityRequirement;
            return this;
        }

        @Override
        public GameModeFindConfig build() {
            return new GameModeFindConfig(this.enabled, this.identityRequirement, this.verification);
        }
    }

    public static interface _FinalStage {
        public GameModeFindConfig build();

        public _FinalStage identityRequirement(Optional<GameModeIdentityRequirement> var1);

        public _FinalStage identityRequirement(GameModeIdentityRequirement var1);

        public _FinalStage verification(Optional<GameModeVerificationConfig> var1);

        public _FinalStage verification(GameModeVerificationConfig var1);
    }

    public static interface EnabledStage {
        public _FinalStage enabled(boolean var1);

        public Builder from(GameModeFindConfig var1);
    }
}

