/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.gamemode.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeIdentityRequirement;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeVerificationConfig;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeCreateConfig {
    private final boolean enabled;
    private final Optional<GameModeIdentityRequirement> identityRequirement;
    private final Optional<GameModeVerificationConfig> verification;
    private final Optional<Boolean> enablePublic;
    private final Optional<Boolean> enablePrivate;
    private final Optional<Integer> maxLobbiesPerIdentity;

    private GameModeCreateConfig(boolean enabled, Optional<GameModeIdentityRequirement> identityRequirement, Optional<GameModeVerificationConfig> verification, Optional<Boolean> enablePublic, Optional<Boolean> enablePrivate, Optional<Integer> maxLobbiesPerIdentity) {
        this.enabled = enabled;
        this.identityRequirement = identityRequirement;
        this.verification = verification;
        this.enablePublic = enablePublic;
        this.enablePrivate = enablePrivate;
        this.maxLobbiesPerIdentity = maxLobbiesPerIdentity;
    }

    @JsonProperty(value="enabled")
    public boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="identity_requirement")
    public Optional<GameModeIdentityRequirement> getIdentityRequirement() {
        return this.identityRequirement;
    }

    @JsonProperty(value="verification")
    public Optional<GameModeVerificationConfig> getVerification() {
        return this.verification;
    }

    @JsonProperty(value="enable_public")
    public Optional<Boolean> getEnablePublic() {
        return this.enablePublic;
    }

    @JsonProperty(value="enable_private")
    public Optional<Boolean> getEnablePrivate() {
        return this.enablePrivate;
    }

    @JsonProperty(value="max_lobbies_per_identity")
    public Optional<Integer> getMaxLobbiesPerIdentity() {
        return this.maxLobbiesPerIdentity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeCreateConfig && this.equalTo((GameModeCreateConfig)other);
    }

    private boolean equalTo(GameModeCreateConfig other) {
        return this.enabled == other.enabled && this.identityRequirement.equals(other.identityRequirement) && this.verification.equals(other.verification) && this.enablePublic.equals(other.enablePublic) && this.enablePrivate.equals(other.enablePrivate) && this.maxLobbiesPerIdentity.equals(other.maxLobbiesPerIdentity);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.identityRequirement, this.verification, this.enablePublic, this.enablePrivate, this.maxLobbiesPerIdentity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EnabledStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EnabledStage,
    _FinalStage {
        private boolean enabled;
        private Optional<Integer> maxLobbiesPerIdentity = Optional.empty();
        private Optional<Boolean> enablePrivate = Optional.empty();
        private Optional<Boolean> enablePublic = Optional.empty();
        private Optional<GameModeVerificationConfig> verification = Optional.empty();
        private Optional<GameModeIdentityRequirement> identityRequirement = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameModeCreateConfig other) {
            this.enabled(other.getEnabled());
            this.identityRequirement(other.getIdentityRequirement());
            this.verification(other.getVerification());
            this.enablePublic(other.getEnablePublic());
            this.enablePrivate(other.getEnablePrivate());
            this.maxLobbiesPerIdentity(other.getMaxLobbiesPerIdentity());
            return this;
        }

        @Override
        @JsonSetter(value="enabled")
        public _FinalStage enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public _FinalStage maxLobbiesPerIdentity(Integer maxLobbiesPerIdentity) {
            this.maxLobbiesPerIdentity = Optional.of(maxLobbiesPerIdentity);
            return this;
        }

        @Override
        @JsonSetter(value="max_lobbies_per_identity", nulls=Nulls.SKIP)
        public _FinalStage maxLobbiesPerIdentity(Optional<Integer> maxLobbiesPerIdentity) {
            this.maxLobbiesPerIdentity = maxLobbiesPerIdentity;
            return this;
        }

        @Override
        public _FinalStage enablePrivate(Boolean enablePrivate) {
            this.enablePrivate = Optional.of(enablePrivate);
            return this;
        }

        @Override
        @JsonSetter(value="enable_private", nulls=Nulls.SKIP)
        public _FinalStage enablePrivate(Optional<Boolean> enablePrivate) {
            this.enablePrivate = enablePrivate;
            return this;
        }

        @Override
        public _FinalStage enablePublic(Boolean enablePublic) {
            this.enablePublic = Optional.of(enablePublic);
            return this;
        }

        @Override
        @JsonSetter(value="enable_public", nulls=Nulls.SKIP)
        public _FinalStage enablePublic(Optional<Boolean> enablePublic) {
            this.enablePublic = enablePublic;
            return this;
        }

        @Override
        public _FinalStage verification(GameModeVerificationConfig verification) {
            this.verification = Optional.of(verification);
            return this;
        }

        @Override
        @JsonSetter(value="verification", nulls=Nulls.SKIP)
        public _FinalStage verification(Optional<GameModeVerificationConfig> verification) {
            this.verification = verification;
            return this;
        }

        @Override
        public _FinalStage identityRequirement(GameModeIdentityRequirement identityRequirement) {
            this.identityRequirement = Optional.of(identityRequirement);
            return this;
        }

        @Override
        @JsonSetter(value="identity_requirement", nulls=Nulls.SKIP)
        public _FinalStage identityRequirement(Optional<GameModeIdentityRequirement> identityRequirement) {
            this.identityRequirement = identityRequirement;
            return this;
        }

        @Override
        public GameModeCreateConfig build() {
            return new GameModeCreateConfig(this.enabled, this.identityRequirement, this.verification, this.enablePublic, this.enablePrivate, this.maxLobbiesPerIdentity);
        }
    }

    public static interface _FinalStage {
        public GameModeCreateConfig build();

        public _FinalStage identityRequirement(Optional<GameModeIdentityRequirement> var1);

        public _FinalStage identityRequirement(GameModeIdentityRequirement var1);

        public _FinalStage verification(Optional<GameModeVerificationConfig> var1);

        public _FinalStage verification(GameModeVerificationConfig var1);

        public _FinalStage enablePublic(Optional<Boolean> var1);

        public _FinalStage enablePublic(Boolean var1);

        public _FinalStage enablePrivate(Optional<Boolean> var1);

        public _FinalStage enablePrivate(Boolean var1);

        public _FinalStage maxLobbiesPerIdentity(Optional<Integer> var1);

        public _FinalStage maxLobbiesPerIdentity(Integer var1);
    }

    public static interface EnabledStage {
        public _FinalStage enabled(boolean var1);

        public Builder from(GameModeCreateConfig var1);
    }
}

