/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CaptchaTurnstile {
    private final String siteKey;
    private final String secretKey;

    private CaptchaTurnstile(String siteKey, String secretKey) {
        this.siteKey = siteKey;
        this.secretKey = secretKey;
    }

    @JsonProperty(value="site_key")
    public String getSiteKey() {
        return this.siteKey;
    }

    @JsonProperty(value="secret_key")
    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CaptchaTurnstile && this.equalTo((CaptchaTurnstile)other);
    }

    private boolean equalTo(CaptchaTurnstile other) {
        return this.siteKey.equals(other.siteKey) && this.secretKey.equals(other.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.siteKey, this.secretKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SiteKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SiteKeyStage,
    SecretKeyStage,
    _FinalStage {
        private String siteKey;
        private String secretKey;

        private Builder() {
        }

        @Override
        public Builder from(CaptchaTurnstile other) {
            this.siteKey(other.getSiteKey());
            this.secretKey(other.getSecretKey());
            return this;
        }

        @Override
        @JsonSetter(value="site_key")
        public SecretKeyStage siteKey(String siteKey) {
            this.siteKey = siteKey;
            return this;
        }

        @Override
        @JsonSetter(value="secret_key")
        public _FinalStage secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        @Override
        public CaptchaTurnstile build() {
            return new CaptchaTurnstile(this.siteKey, this.secretKey);
        }
    }

    public static interface _FinalStage {
        public CaptchaTurnstile build();
    }

    public static interface SecretKeyStage {
        public _FinalStage secretKey(String var1);
    }

    public static interface SiteKeyStage {
        public SecretKeyStage siteKey(String var1);

        public Builder from(CaptchaTurnstile var1);
    }
}

