/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.cdn.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.cdn.types.Middleware;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Route {
    private final String glob;
    private final int priority;
    private final List<Middleware> middlewares;

    private Route(String glob, int priority, List<Middleware> middlewares) {
        this.glob = glob;
        this.priority = priority;
        this.middlewares = middlewares;
    }

    @JsonProperty(value="glob")
    public String getGlob() {
        return this.glob;
    }

    @JsonProperty(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @JsonProperty(value="middlewares")
    public List<Middleware> getMiddlewares() {
        return this.middlewares;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Route && this.equalTo((Route)other);
    }

    private boolean equalTo(Route other) {
        return this.glob.equals(other.glob) && this.priority == other.priority && this.middlewares.equals(other.middlewares);
    }

    public int hashCode() {
        return Objects.hash(this.glob, this.priority, this.middlewares);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GlobStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GlobStage,
    PriorityStage,
    _FinalStage {
        private String glob;
        private int priority;
        private List<Middleware> middlewares = new ArrayList<Middleware>();

        private Builder() {
        }

        @Override
        public Builder from(Route other) {
            this.glob(other.getGlob());
            this.priority(other.getPriority());
            this.middlewares(other.getMiddlewares());
            return this;
        }

        @Override
        @JsonSetter(value="glob")
        public PriorityStage glob(String glob) {
            this.glob = glob;
            return this;
        }

        @Override
        @JsonSetter(value="priority")
        public _FinalStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public _FinalStage addAllMiddlewares(List<Middleware> middlewares) {
            this.middlewares.addAll(middlewares);
            return this;
        }

        @Override
        public _FinalStage addMiddlewares(Middleware middlewares) {
            this.middlewares.add(middlewares);
            return this;
        }

        @Override
        @JsonSetter(value="middlewares", nulls=Nulls.SKIP)
        public _FinalStage middlewares(List<Middleware> middlewares) {
            this.middlewares.clear();
            this.middlewares.addAll(middlewares);
            return this;
        }

        @Override
        public Route build() {
            return new Route(this.glob, this.priority, this.middlewares);
        }
    }

    public static interface _FinalStage {
        public Route build();

        public _FinalStage middlewares(List<Middleware> var1);

        public _FinalStage addMiddlewares(Middleware var1);

        public _FinalStage addAllMiddlewares(List<Middleware> var1);
    }

    public static interface PriorityStage {
        public _FinalStage priority(int var1);
    }

    public static interface GlobStage {
        public PriorityStage glob(String var1);

        public Builder from(Route var1);
    }
}

