/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.cdn.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Header {
    private final String name;
    private final String value;

    private Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Header && this.equalTo((Header)other);
    }

    private boolean equalTo(Header other) {
        return this.name.equals(other.name) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    ValueStage,
    _FinalStage {
        private String name;
        private String value;

        private Builder() {
        }

        @Override
        public Builder from(Header other) {
            this.name(other.getName());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ValueStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Header build() {
            return new Header(this.name, this.value);
        }
    }

    public static interface _FinalStage {
        public Header build();
    }

    public static interface ValueStage {
        public _FinalStage value(String var1);
    }

    public static interface NameStage {
        public ValueStage name(String var1);

        public Builder from(Header var1);
    }
}

