/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.types.BootstrapCaptcha;
import com.rivet.api.resources.cloud.types.BootstrapCluster;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class BootstrapResponse {
    private final BootstrapCluster cluster;
    private final BootstrapCaptcha captcha;

    private BootstrapResponse(BootstrapCluster cluster, BootstrapCaptcha captcha) {
        this.cluster = cluster;
        this.captcha = captcha;
    }

    @JsonProperty(value="cluster")
    public BootstrapCluster getCluster() {
        return this.cluster;
    }

    @JsonProperty(value="captcha")
    public BootstrapCaptcha getCaptcha() {
        return this.captcha;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BootstrapResponse && this.equalTo((BootstrapResponse)other);
    }

    private boolean equalTo(BootstrapResponse other) {
        return this.cluster.equals((Object)other.cluster) && this.captcha.equals(other.captcha);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cluster, this.captcha});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ClusterStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ClusterStage,
    CaptchaStage,
    _FinalStage {
        private BootstrapCluster cluster;
        private BootstrapCaptcha captcha;

        private Builder() {
        }

        @Override
        public Builder from(BootstrapResponse other) {
            this.cluster(other.getCluster());
            this.captcha(other.getCaptcha());
            return this;
        }

        @Override
        @JsonSetter(value="cluster")
        public CaptchaStage cluster(BootstrapCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        @Override
        @JsonSetter(value="captcha")
        public _FinalStage captcha(BootstrapCaptcha captcha) {
            this.captcha = captcha;
            return this;
        }

        @Override
        public BootstrapResponse build() {
            return new BootstrapResponse(this.cluster, this.captcha);
        }
    }

    public static interface _FinalStage {
        public BootstrapResponse build();
    }

    public static interface CaptchaStage {
        public _FinalStage captcha(BootstrapCaptcha var1);
    }

    public static interface ClusterStage {
        public CaptchaStage cluster(BootstrapCluster var1);

        public Builder from(BootstrapResponse var1);
    }
}

