/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.namespaces.logs.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.LogsLobbySummary;
import com.rivet.api.resources.cloud.common.types.SvcMetrics;
import com.rivet.api.resources.cloud.common.types.SvcPerf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetNamespaceLobbyResponse {
    private final LogsLobbySummary lobby;
    private final Optional<SvcMetrics> metrics;
    private final List<String> stdoutPresignedUrls;
    private final List<String> stderrPresignedUrls;
    private final List<SvcPerf> perfLists;

    private GetNamespaceLobbyResponse(LogsLobbySummary lobby, Optional<SvcMetrics> metrics, List<String> stdoutPresignedUrls, List<String> stderrPresignedUrls, List<SvcPerf> perfLists) {
        this.lobby = lobby;
        this.metrics = metrics;
        this.stdoutPresignedUrls = stdoutPresignedUrls;
        this.stderrPresignedUrls = stderrPresignedUrls;
        this.perfLists = perfLists;
    }

    @JsonProperty(value="lobby")
    public LogsLobbySummary getLobby() {
        return this.lobby;
    }

    @JsonProperty(value="metrics")
    public Optional<SvcMetrics> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="stdout_presigned_urls")
    public List<String> getStdoutPresignedUrls() {
        return this.stdoutPresignedUrls;
    }

    @JsonProperty(value="stderr_presigned_urls")
    public List<String> getStderrPresignedUrls() {
        return this.stderrPresignedUrls;
    }

    @JsonProperty(value="perf_lists")
    public List<SvcPerf> getPerfLists() {
        return this.perfLists;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetNamespaceLobbyResponse && this.equalTo((GetNamespaceLobbyResponse)other);
    }

    private boolean equalTo(GetNamespaceLobbyResponse other) {
        return this.lobby.equals(other.lobby) && this.metrics.equals(other.metrics) && this.stdoutPresignedUrls.equals(other.stdoutPresignedUrls) && this.stderrPresignedUrls.equals(other.stderrPresignedUrls) && this.perfLists.equals(other.perfLists);
    }

    public int hashCode() {
        return Objects.hash(this.lobby, this.metrics, this.stdoutPresignedUrls, this.stderrPresignedUrls, this.perfLists);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LobbyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LobbyStage,
    _FinalStage {
        private LogsLobbySummary lobby;
        private List<SvcPerf> perfLists = new ArrayList<SvcPerf>();
        private List<String> stderrPresignedUrls = new ArrayList<String>();
        private List<String> stdoutPresignedUrls = new ArrayList<String>();
        private Optional<SvcMetrics> metrics = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetNamespaceLobbyResponse other) {
            this.lobby(other.getLobby());
            this.metrics(other.getMetrics());
            this.stdoutPresignedUrls(other.getStdoutPresignedUrls());
            this.stderrPresignedUrls(other.getStderrPresignedUrls());
            this.perfLists(other.getPerfLists());
            return this;
        }

        @Override
        @JsonSetter(value="lobby")
        public _FinalStage lobby(LogsLobbySummary lobby) {
            this.lobby = lobby;
            return this;
        }

        @Override
        public _FinalStage addAllPerfLists(List<SvcPerf> perfLists) {
            this.perfLists.addAll(perfLists);
            return this;
        }

        @Override
        public _FinalStage addPerfLists(SvcPerf perfLists) {
            this.perfLists.add(perfLists);
            return this;
        }

        @Override
        @JsonSetter(value="perf_lists", nulls=Nulls.SKIP)
        public _FinalStage perfLists(List<SvcPerf> perfLists) {
            this.perfLists.clear();
            this.perfLists.addAll(perfLists);
            return this;
        }

        @Override
        public _FinalStage addAllStderrPresignedUrls(List<String> stderrPresignedUrls) {
            this.stderrPresignedUrls.addAll(stderrPresignedUrls);
            return this;
        }

        @Override
        public _FinalStage addStderrPresignedUrls(String stderrPresignedUrls) {
            this.stderrPresignedUrls.add(stderrPresignedUrls);
            return this;
        }

        @Override
        @JsonSetter(value="stderr_presigned_urls", nulls=Nulls.SKIP)
        public _FinalStage stderrPresignedUrls(List<String> stderrPresignedUrls) {
            this.stderrPresignedUrls.clear();
            this.stderrPresignedUrls.addAll(stderrPresignedUrls);
            return this;
        }

        @Override
        public _FinalStage addAllStdoutPresignedUrls(List<String> stdoutPresignedUrls) {
            this.stdoutPresignedUrls.addAll(stdoutPresignedUrls);
            return this;
        }

        @Override
        public _FinalStage addStdoutPresignedUrls(String stdoutPresignedUrls) {
            this.stdoutPresignedUrls.add(stdoutPresignedUrls);
            return this;
        }

        @Override
        @JsonSetter(value="stdout_presigned_urls", nulls=Nulls.SKIP)
        public _FinalStage stdoutPresignedUrls(List<String> stdoutPresignedUrls) {
            this.stdoutPresignedUrls.clear();
            this.stdoutPresignedUrls.addAll(stdoutPresignedUrls);
            return this;
        }

        @Override
        public _FinalStage metrics(SvcMetrics metrics) {
            this.metrics = Optional.of(metrics);
            return this;
        }

        @Override
        @JsonSetter(value="metrics", nulls=Nulls.SKIP)
        public _FinalStage metrics(Optional<SvcMetrics> metrics) {
            this.metrics = metrics;
            return this;
        }

        @Override
        public GetNamespaceLobbyResponse build() {
            return new GetNamespaceLobbyResponse(this.lobby, this.metrics, this.stdoutPresignedUrls, this.stderrPresignedUrls, this.perfLists);
        }
    }

    public static interface _FinalStage {
        public GetNamespaceLobbyResponse build();

        public _FinalStage metrics(Optional<SvcMetrics> var1);

        public _FinalStage metrics(SvcMetrics var1);

        public _FinalStage stdoutPresignedUrls(List<String> var1);

        public _FinalStage addStdoutPresignedUrls(String var1);

        public _FinalStage addAllStdoutPresignedUrls(List<String> var1);

        public _FinalStage stderrPresignedUrls(List<String> var1);

        public _FinalStage addStderrPresignedUrls(String var1);

        public _FinalStage addAllStderrPresignedUrls(List<String> var1);

        public _FinalStage perfLists(List<SvcPerf> var1);

        public _FinalStage addPerfLists(SvcPerf var1);

        public _FinalStage addAllPerfLists(List<SvcPerf> var1);
    }

    public static interface LobbyStage {
        public _FinalStage lobby(LogsLobbySummary var1);

        public Builder from(GetNamespaceLobbyResponse var1);
    }
}

