/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.games.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.game.common.types.Summary;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetGamesResponse {
    private final List<Summary> games;
    private final List<com.rivet.api.resources.group.common.types.Summary> groups;
    private final WatchResponse watch;

    private GetGamesResponse(List<Summary> games, List<com.rivet.api.resources.group.common.types.Summary> groups, WatchResponse watch) {
        this.games = games;
        this.groups = groups;
        this.watch = watch;
    }

    @JsonProperty(value="games")
    public List<Summary> getGames() {
        return this.games;
    }

    @JsonProperty(value="groups")
    public List<com.rivet.api.resources.group.common.types.Summary> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetGamesResponse && this.equalTo((GetGamesResponse)other);
    }

    private boolean equalTo(GetGamesResponse other) {
        return this.games.equals(other.games) && this.groups.equals(other.groups) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.games, this.groups, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private List<com.rivet.api.resources.group.common.types.Summary> groups = new ArrayList<com.rivet.api.resources.group.common.types.Summary>();
        private List<Summary> games = new ArrayList<Summary>();

        private Builder() {
        }

        @Override
        public Builder from(GetGamesResponse other) {
            this.games(other.getGames());
            this.groups(other.getGroups());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage addAllGroups(List<com.rivet.api.resources.group.common.types.Summary> groups) {
            this.groups.addAll(groups);
            return this;
        }

        @Override
        public _FinalStage addGroups(com.rivet.api.resources.group.common.types.Summary groups) {
            this.groups.add(groups);
            return this;
        }

        @Override
        @JsonSetter(value="groups", nulls=Nulls.SKIP)
        public _FinalStage groups(List<com.rivet.api.resources.group.common.types.Summary> groups) {
            this.groups.clear();
            this.groups.addAll(groups);
            return this;
        }

        @Override
        public _FinalStage addAllGames(List<Summary> games) {
            this.games.addAll(games);
            return this;
        }

        @Override
        public _FinalStage addGames(Summary games) {
            this.games.add(games);
            return this;
        }

        @Override
        @JsonSetter(value="games", nulls=Nulls.SKIP)
        public _FinalStage games(List<Summary> games) {
            this.games.clear();
            this.games.addAll(games);
            return this;
        }

        @Override
        public GetGamesResponse build() {
            return new GetGamesResponse(this.games, this.groups, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetGamesResponse build();

        public _FinalStage games(List<Summary> var1);

        public _FinalStage addGames(Summary var1);

        public _FinalStage addAllGames(List<Summary> var1);

        public _FinalStage groups(List<com.rivet.api.resources.group.common.types.Summary> var1);

        public _FinalStage addGroups(com.rivet.api.resources.group.common.types.Summary var1);

        public _FinalStage addAllGroups(List<com.rivet.api.resources.group.common.types.Summary> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetGamesResponse var1);
    }
}

