/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.games.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateGameRequest {
    private final String nameId;
    private final String displayName;
    private final UUID developerGroupId;

    private CreateGameRequest(String nameId, String displayName, UUID developerGroupId) {
        this.nameId = nameId;
        this.displayName = displayName;
        this.developerGroupId = developerGroupId;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="developer_group_id")
    public UUID getDeveloperGroupId() {
        return this.developerGroupId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGameRequest && this.equalTo((CreateGameRequest)other);
    }

    private boolean equalTo(CreateGameRequest other) {
        return this.nameId.equals(other.nameId) && this.displayName.equals(other.displayName) && this.developerGroupId.equals(other.developerGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.nameId, this.displayName, this.developerGroupId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameIdStage,
    DisplayNameStage,
    DeveloperGroupIdStage,
    _FinalStage {
        private String nameId;
        private String displayName;
        private UUID developerGroupId;

        private Builder() {
        }

        @Override
        public Builder from(CreateGameRequest other) {
            this.nameId(other.getNameId());
            this.displayName(other.getDisplayName());
            this.developerGroupId(other.getDeveloperGroupId());
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public DisplayNameStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public DeveloperGroupIdStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="developer_group_id")
        public _FinalStage developerGroupId(UUID developerGroupId) {
            this.developerGroupId = developerGroupId;
            return this;
        }

        @Override
        public CreateGameRequest build() {
            return new CreateGameRequest(this.nameId, this.displayName, this.developerGroupId);
        }
    }

    public static interface _FinalStage {
        public CreateGameRequest build();
    }

    public static interface DeveloperGroupIdStage {
        public _FinalStage developerGroupId(UUID var1);
    }

    public static interface DisplayNameStage {
        public DeveloperGroupIdStage displayName(String var1);
    }

    public static interface NameIdStage {
        public DisplayNameStage nameId(String var1);

        public Builder from(CreateGameRequest var1);
    }
}

