/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RegionTier {
    private final String tierNameId;
    private final int rivetCoresNumerator;
    private final int rivetCoresDenominator;
    private final int cpu;
    private final int memory;
    private final int disk;
    private final int bandwidth;
    private final int pricePerSecond;

    private RegionTier(String tierNameId, int rivetCoresNumerator, int rivetCoresDenominator, int cpu, int memory, int disk, int bandwidth, int pricePerSecond) {
        this.tierNameId = tierNameId;
        this.rivetCoresNumerator = rivetCoresNumerator;
        this.rivetCoresDenominator = rivetCoresDenominator;
        this.cpu = cpu;
        this.memory = memory;
        this.disk = disk;
        this.bandwidth = bandwidth;
        this.pricePerSecond = pricePerSecond;
    }

    @JsonProperty(value="tier_name_id")
    public String getTierNameId() {
        return this.tierNameId;
    }

    @JsonProperty(value="rivet_cores_numerator")
    public int getRivetCoresNumerator() {
        return this.rivetCoresNumerator;
    }

    @JsonProperty(value="rivet_cores_denominator")
    public int getRivetCoresDenominator() {
        return this.rivetCoresDenominator;
    }

    @JsonProperty(value="cpu")
    public int getCpu() {
        return this.cpu;
    }

    @JsonProperty(value="memory")
    public int getMemory() {
        return this.memory;
    }

    @JsonProperty(value="disk")
    public int getDisk() {
        return this.disk;
    }

    @JsonProperty(value="bandwidth")
    public int getBandwidth() {
        return this.bandwidth;
    }

    @JsonProperty(value="price_per_second")
    public int getPricePerSecond() {
        return this.pricePerSecond;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RegionTier && this.equalTo((RegionTier)other);
    }

    private boolean equalTo(RegionTier other) {
        return this.tierNameId.equals(other.tierNameId) && this.rivetCoresNumerator == other.rivetCoresNumerator && this.rivetCoresDenominator == other.rivetCoresDenominator && this.cpu == other.cpu && this.memory == other.memory && this.disk == other.disk && this.bandwidth == other.bandwidth && this.pricePerSecond == other.pricePerSecond;
    }

    public int hashCode() {
        return Objects.hash(this.tierNameId, this.rivetCoresNumerator, this.rivetCoresDenominator, this.cpu, this.memory, this.disk, this.bandwidth, this.pricePerSecond);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TierNameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TierNameIdStage,
    RivetCoresNumeratorStage,
    RivetCoresDenominatorStage,
    CpuStage,
    MemoryStage,
    DiskStage,
    BandwidthStage,
    PricePerSecondStage,
    _FinalStage {
        private String tierNameId;
        private int rivetCoresNumerator;
        private int rivetCoresDenominator;
        private int cpu;
        private int memory;
        private int disk;
        private int bandwidth;
        private int pricePerSecond;

        private Builder() {
        }

        @Override
        public Builder from(RegionTier other) {
            this.tierNameId(other.getTierNameId());
            this.rivetCoresNumerator(other.getRivetCoresNumerator());
            this.rivetCoresDenominator(other.getRivetCoresDenominator());
            this.cpu(other.getCpu());
            this.memory(other.getMemory());
            this.disk(other.getDisk());
            this.bandwidth(other.getBandwidth());
            this.pricePerSecond(other.getPricePerSecond());
            return this;
        }

        @Override
        @JsonSetter(value="tier_name_id")
        public RivetCoresNumeratorStage tierNameId(String tierNameId) {
            this.tierNameId = tierNameId;
            return this;
        }

        @Override
        @JsonSetter(value="rivet_cores_numerator")
        public RivetCoresDenominatorStage rivetCoresNumerator(int rivetCoresNumerator) {
            this.rivetCoresNumerator = rivetCoresNumerator;
            return this;
        }

        @Override
        @JsonSetter(value="rivet_cores_denominator")
        public CpuStage rivetCoresDenominator(int rivetCoresDenominator) {
            this.rivetCoresDenominator = rivetCoresDenominator;
            return this;
        }

        @Override
        @JsonSetter(value="cpu")
        public MemoryStage cpu(int cpu) {
            this.cpu = cpu;
            return this;
        }

        @Override
        @JsonSetter(value="memory")
        public DiskStage memory(int memory) {
            this.memory = memory;
            return this;
        }

        @Override
        @JsonSetter(value="disk")
        public BandwidthStage disk(int disk) {
            this.disk = disk;
            return this;
        }

        @Override
        @JsonSetter(value="bandwidth")
        public PricePerSecondStage bandwidth(int bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        @Override
        @JsonSetter(value="price_per_second")
        public _FinalStage pricePerSecond(int pricePerSecond) {
            this.pricePerSecond = pricePerSecond;
            return this;
        }

        @Override
        public RegionTier build() {
            return new RegionTier(this.tierNameId, this.rivetCoresNumerator, this.rivetCoresDenominator, this.cpu, this.memory, this.disk, this.bandwidth, this.pricePerSecond);
        }
    }

    public static interface _FinalStage {
        public RegionTier build();
    }

    public static interface PricePerSecondStage {
        public _FinalStage pricePerSecond(int var1);
    }

    public static interface BandwidthStage {
        public PricePerSecondStage bandwidth(int var1);
    }

    public static interface DiskStage {
        public BandwidthStage disk(int var1);
    }

    public static interface MemoryStage {
        public DiskStage memory(int var1);
    }

    public static interface CpuStage {
        public MemoryStage cpu(int var1);
    }

    public static interface RivetCoresDenominatorStage {
        public CpuStage rivetCoresDenominator(int var1);
    }

    public static interface RivetCoresNumeratorStage {
        public RivetCoresDenominatorStage rivetCoresNumerator(int var1);
    }

    public static interface TierNameIdStage {
        public RivetCoresNumeratorStage tierNameId(String var1);

        public Builder from(RegionTier var1);
    }
}

