/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.UniversalRegion;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RegionSummary {
    private final UUID regionId;
    private final String regionNameId;
    private final String provider;
    private final UniversalRegion universalRegion;
    private final String providerDisplayName;
    private final String regionDisplayName;

    private RegionSummary(UUID regionId, String regionNameId, String provider, UniversalRegion universalRegion, String providerDisplayName, String regionDisplayName) {
        this.regionId = regionId;
        this.regionNameId = regionNameId;
        this.provider = provider;
        this.universalRegion = universalRegion;
        this.providerDisplayName = providerDisplayName;
        this.regionDisplayName = regionDisplayName;
    }

    @JsonProperty(value="region_id")
    public UUID getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="region_name_id")
    public String getRegionNameId() {
        return this.regionNameId;
    }

    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    @JsonProperty(value="universal_region")
    public UniversalRegion getUniversalRegion() {
        return this.universalRegion;
    }

    @JsonProperty(value="provider_display_name")
    public String getProviderDisplayName() {
        return this.providerDisplayName;
    }

    @JsonProperty(value="region_display_name")
    public String getRegionDisplayName() {
        return this.regionDisplayName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RegionSummary && this.equalTo((RegionSummary)other);
    }

    private boolean equalTo(RegionSummary other) {
        return this.regionId.equals(other.regionId) && this.regionNameId.equals(other.regionNameId) && this.provider.equals(other.provider) && this.universalRegion.equals((Object)other.universalRegion) && this.providerDisplayName.equals(other.providerDisplayName) && this.regionDisplayName.equals(other.regionDisplayName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.regionId, this.regionNameId, this.provider, this.universalRegion, this.providerDisplayName, this.regionDisplayName});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RegionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RegionIdStage,
    RegionNameIdStage,
    ProviderStage,
    UniversalRegionStage,
    ProviderDisplayNameStage,
    RegionDisplayNameStage,
    _FinalStage {
        private UUID regionId;
        private String regionNameId;
        private String provider;
        private UniversalRegion universalRegion;
        private String providerDisplayName;
        private String regionDisplayName;

        private Builder() {
        }

        @Override
        public Builder from(RegionSummary other) {
            this.regionId(other.getRegionId());
            this.regionNameId(other.getRegionNameId());
            this.provider(other.getProvider());
            this.universalRegion(other.getUniversalRegion());
            this.providerDisplayName(other.getProviderDisplayName());
            this.regionDisplayName(other.getRegionDisplayName());
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public RegionNameIdStage regionId(UUID regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="region_name_id")
        public ProviderStage regionNameId(String regionNameId) {
            this.regionNameId = regionNameId;
            return this;
        }

        @Override
        @JsonSetter(value="provider")
        public UniversalRegionStage provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        @JsonSetter(value="universal_region")
        public ProviderDisplayNameStage universalRegion(UniversalRegion universalRegion) {
            this.universalRegion = universalRegion;
            return this;
        }

        @Override
        @JsonSetter(value="provider_display_name")
        public RegionDisplayNameStage providerDisplayName(String providerDisplayName) {
            this.providerDisplayName = providerDisplayName;
            return this;
        }

        @Override
        @JsonSetter(value="region_display_name")
        public _FinalStage regionDisplayName(String regionDisplayName) {
            this.regionDisplayName = regionDisplayName;
            return this;
        }

        @Override
        public RegionSummary build() {
            return new RegionSummary(this.regionId, this.regionNameId, this.provider, this.universalRegion, this.providerDisplayName, this.regionDisplayName);
        }
    }

    public static interface _FinalStage {
        public RegionSummary build();
    }

    public static interface RegionDisplayNameStage {
        public _FinalStage regionDisplayName(String var1);
    }

    public static interface ProviderDisplayNameStage {
        public RegionDisplayNameStage providerDisplayName(String var1);
    }

    public static interface UniversalRegionStage {
        public ProviderDisplayNameStage universalRegion(UniversalRegion var1);
    }

    public static interface ProviderStage {
        public UniversalRegionStage provider(String var1);
    }

    public static interface RegionNameIdStage {
        public ProviderStage regionNameId(String var1);
    }

    public static interface RegionIdStage {
        public RegionNameIdStage regionId(UUID var1);

        public Builder from(RegionSummary var1);
    }
}

