/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.CdnNamespaceConfig;
import com.rivet.api.resources.cloud.common.types.IdentityNamespaceConfig;
import com.rivet.api.resources.cloud.common.types.KvNamespaceConfig;
import com.rivet.api.resources.cloud.common.types.MatchmakerNamespaceConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class NamespaceConfig {
    private final CdnNamespaceConfig cdn;
    private final MatchmakerNamespaceConfig matchmaker;
    private final KvNamespaceConfig kv;
    private final IdentityNamespaceConfig identity;

    private NamespaceConfig(CdnNamespaceConfig cdn, MatchmakerNamespaceConfig matchmaker, KvNamespaceConfig kv, IdentityNamespaceConfig identity) {
        this.cdn = cdn;
        this.matchmaker = matchmaker;
        this.kv = kv;
        this.identity = identity;
    }

    @JsonProperty(value="cdn")
    public CdnNamespaceConfig getCdn() {
        return this.cdn;
    }

    @JsonProperty(value="matchmaker")
    public MatchmakerNamespaceConfig getMatchmaker() {
        return this.matchmaker;
    }

    @JsonProperty(value="kv")
    public KvNamespaceConfig getKv() {
        return this.kv;
    }

    @JsonProperty(value="identity")
    public IdentityNamespaceConfig getIdentity() {
        return this.identity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NamespaceConfig && this.equalTo((NamespaceConfig)other);
    }

    private boolean equalTo(NamespaceConfig other) {
        return this.cdn.equals(other.cdn) && this.matchmaker.equals(other.matchmaker) && this.kv.equals(other.kv) && this.identity.equals(other.identity);
    }

    public int hashCode() {
        return Objects.hash(this.cdn, this.matchmaker, this.kv, this.identity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CdnStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CdnStage,
    MatchmakerStage,
    KvStage,
    IdentityStage,
    _FinalStage {
        private CdnNamespaceConfig cdn;
        private MatchmakerNamespaceConfig matchmaker;
        private KvNamespaceConfig kv;
        private IdentityNamespaceConfig identity;

        private Builder() {
        }

        @Override
        public Builder from(NamespaceConfig other) {
            this.cdn(other.getCdn());
            this.matchmaker(other.getMatchmaker());
            this.kv(other.getKv());
            this.identity(other.getIdentity());
            return this;
        }

        @Override
        @JsonSetter(value="cdn")
        public MatchmakerStage cdn(CdnNamespaceConfig cdn) {
            this.cdn = cdn;
            return this;
        }

        @Override
        @JsonSetter(value="matchmaker")
        public KvStage matchmaker(MatchmakerNamespaceConfig matchmaker) {
            this.matchmaker = matchmaker;
            return this;
        }

        @Override
        @JsonSetter(value="kv")
        public IdentityStage kv(KvNamespaceConfig kv) {
            this.kv = kv;
            return this;
        }

        @Override
        @JsonSetter(value="identity")
        public _FinalStage identity(IdentityNamespaceConfig identity) {
            this.identity = identity;
            return this;
        }

        @Override
        public NamespaceConfig build() {
            return new NamespaceConfig(this.cdn, this.matchmaker, this.kv, this.identity);
        }
    }

    public static interface _FinalStage {
        public NamespaceConfig build();
    }

    public static interface IdentityStage {
        public _FinalStage identity(IdentityNamespaceConfig var1);
    }

    public static interface KvStage {
        public IdentityStage kv(KvNamespaceConfig var1);
    }

    public static interface MatchmakerStage {
        public KvStage matchmaker(MatchmakerNamespaceConfig var1);
    }

    public static interface CdnStage {
        public MatchmakerStage cdn(CdnNamespaceConfig var1);

        public Builder from(NamespaceConfig var1);
    }
}

