/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LobbySummaryAnalytics {
    private final UUID lobbyId;
    private final UUID lobbyGroupId;
    private final String lobbyGroupNameId;
    private final UUID regionId;
    private final OffsetDateTime createTs;
    private final boolean isReady;
    private final boolean isIdle;
    private final boolean isClosed;
    private final boolean isOutdated;
    private final int maxPlayersNormal;
    private final int maxPlayersDirect;
    private final int maxPlayersParty;
    private final int totalPlayerCount;
    private final int registeredPlayerCount;

    private LobbySummaryAnalytics(UUID lobbyId, UUID lobbyGroupId, String lobbyGroupNameId, UUID regionId, OffsetDateTime createTs, boolean isReady, boolean isIdle, boolean isClosed, boolean isOutdated, int maxPlayersNormal, int maxPlayersDirect, int maxPlayersParty, int totalPlayerCount, int registeredPlayerCount) {
        this.lobbyId = lobbyId;
        this.lobbyGroupId = lobbyGroupId;
        this.lobbyGroupNameId = lobbyGroupNameId;
        this.regionId = regionId;
        this.createTs = createTs;
        this.isReady = isReady;
        this.isIdle = isIdle;
        this.isClosed = isClosed;
        this.isOutdated = isOutdated;
        this.maxPlayersNormal = maxPlayersNormal;
        this.maxPlayersDirect = maxPlayersDirect;
        this.maxPlayersParty = maxPlayersParty;
        this.totalPlayerCount = totalPlayerCount;
        this.registeredPlayerCount = registeredPlayerCount;
    }

    @JsonProperty(value="lobby_id")
    public UUID getLobbyId() {
        return this.lobbyId;
    }

    @JsonProperty(value="lobby_group_id")
    public UUID getLobbyGroupId() {
        return this.lobbyGroupId;
    }

    @JsonProperty(value="lobby_group_name_id")
    public String getLobbyGroupNameId() {
        return this.lobbyGroupNameId;
    }

    @JsonProperty(value="region_id")
    public UUID getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="is_ready")
    public boolean getIsReady() {
        return this.isReady;
    }

    @JsonProperty(value="is_idle")
    public boolean getIsIdle() {
        return this.isIdle;
    }

    @JsonProperty(value="is_closed")
    public boolean getIsClosed() {
        return this.isClosed;
    }

    @JsonProperty(value="is_outdated")
    public boolean getIsOutdated() {
        return this.isOutdated;
    }

    @JsonProperty(value="max_players_normal")
    public int getMaxPlayersNormal() {
        return this.maxPlayersNormal;
    }

    @JsonProperty(value="max_players_direct")
    public int getMaxPlayersDirect() {
        return this.maxPlayersDirect;
    }

    @JsonProperty(value="max_players_party")
    public int getMaxPlayersParty() {
        return this.maxPlayersParty;
    }

    @JsonProperty(value="total_player_count")
    public int getTotalPlayerCount() {
        return this.totalPlayerCount;
    }

    @JsonProperty(value="registered_player_count")
    public int getRegisteredPlayerCount() {
        return this.registeredPlayerCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LobbySummaryAnalytics && this.equalTo((LobbySummaryAnalytics)other);
    }

    private boolean equalTo(LobbySummaryAnalytics other) {
        return this.lobbyId.equals(other.lobbyId) && this.lobbyGroupId.equals(other.lobbyGroupId) && this.lobbyGroupNameId.equals(other.lobbyGroupNameId) && this.regionId.equals(other.regionId) && this.createTs.equals(other.createTs) && this.isReady == other.isReady && this.isIdle == other.isIdle && this.isClosed == other.isClosed && this.isOutdated == other.isOutdated && this.maxPlayersNormal == other.maxPlayersNormal && this.maxPlayersDirect == other.maxPlayersDirect && this.maxPlayersParty == other.maxPlayersParty && this.totalPlayerCount == other.totalPlayerCount && this.registeredPlayerCount == other.registeredPlayerCount;
    }

    public int hashCode() {
        return Objects.hash(this.lobbyId, this.lobbyGroupId, this.lobbyGroupNameId, this.regionId, this.createTs, this.isReady, this.isIdle, this.isClosed, this.isOutdated, this.maxPlayersNormal, this.maxPlayersDirect, this.maxPlayersParty, this.totalPlayerCount, this.registeredPlayerCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LobbyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LobbyIdStage,
    LobbyGroupIdStage,
    LobbyGroupNameIdStage,
    RegionIdStage,
    CreateTsStage,
    IsReadyStage,
    IsIdleStage,
    IsClosedStage,
    IsOutdatedStage,
    MaxPlayersNormalStage,
    MaxPlayersDirectStage,
    MaxPlayersPartyStage,
    TotalPlayerCountStage,
    RegisteredPlayerCountStage,
    _FinalStage {
        private UUID lobbyId;
        private UUID lobbyGroupId;
        private String lobbyGroupNameId;
        private UUID regionId;
        private OffsetDateTime createTs;
        private boolean isReady;
        private boolean isIdle;
        private boolean isClosed;
        private boolean isOutdated;
        private int maxPlayersNormal;
        private int maxPlayersDirect;
        private int maxPlayersParty;
        private int totalPlayerCount;
        private int registeredPlayerCount;

        private Builder() {
        }

        @Override
        public Builder from(LobbySummaryAnalytics other) {
            this.lobbyId(other.getLobbyId());
            this.lobbyGroupId(other.getLobbyGroupId());
            this.lobbyGroupNameId(other.getLobbyGroupNameId());
            this.regionId(other.getRegionId());
            this.createTs(other.getCreateTs());
            this.isReady(other.getIsReady());
            this.isIdle(other.getIsIdle());
            this.isClosed(other.getIsClosed());
            this.isOutdated(other.getIsOutdated());
            this.maxPlayersNormal(other.getMaxPlayersNormal());
            this.maxPlayersDirect(other.getMaxPlayersDirect());
            this.maxPlayersParty(other.getMaxPlayersParty());
            this.totalPlayerCount(other.getTotalPlayerCount());
            this.registeredPlayerCount(other.getRegisteredPlayerCount());
            return this;
        }

        @Override
        @JsonSetter(value="lobby_id")
        public LobbyGroupIdStage lobbyId(UUID lobbyId) {
            this.lobbyId = lobbyId;
            return this;
        }

        @Override
        @JsonSetter(value="lobby_group_id")
        public LobbyGroupNameIdStage lobbyGroupId(UUID lobbyGroupId) {
            this.lobbyGroupId = lobbyGroupId;
            return this;
        }

        @Override
        @JsonSetter(value="lobby_group_name_id")
        public RegionIdStage lobbyGroupNameId(String lobbyGroupNameId) {
            this.lobbyGroupNameId = lobbyGroupNameId;
            return this;
        }

        @Override
        @JsonSetter(value="region_id")
        public CreateTsStage regionId(UUID regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public IsReadyStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="is_ready")
        public IsIdleStage isReady(boolean isReady) {
            this.isReady = isReady;
            return this;
        }

        @Override
        @JsonSetter(value="is_idle")
        public IsClosedStage isIdle(boolean isIdle) {
            this.isIdle = isIdle;
            return this;
        }

        @Override
        @JsonSetter(value="is_closed")
        public IsOutdatedStage isClosed(boolean isClosed) {
            this.isClosed = isClosed;
            return this;
        }

        @Override
        @JsonSetter(value="is_outdated")
        public MaxPlayersNormalStage isOutdated(boolean isOutdated) {
            this.isOutdated = isOutdated;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_normal")
        public MaxPlayersDirectStage maxPlayersNormal(int maxPlayersNormal) {
            this.maxPlayersNormal = maxPlayersNormal;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_direct")
        public MaxPlayersPartyStage maxPlayersDirect(int maxPlayersDirect) {
            this.maxPlayersDirect = maxPlayersDirect;
            return this;
        }

        @Override
        @JsonSetter(value="max_players_party")
        public TotalPlayerCountStage maxPlayersParty(int maxPlayersParty) {
            this.maxPlayersParty = maxPlayersParty;
            return this;
        }

        @Override
        @JsonSetter(value="total_player_count")
        public RegisteredPlayerCountStage totalPlayerCount(int totalPlayerCount) {
            this.totalPlayerCount = totalPlayerCount;
            return this;
        }

        @Override
        @JsonSetter(value="registered_player_count")
        public _FinalStage registeredPlayerCount(int registeredPlayerCount) {
            this.registeredPlayerCount = registeredPlayerCount;
            return this;
        }

        @Override
        public LobbySummaryAnalytics build() {
            return new LobbySummaryAnalytics(this.lobbyId, this.lobbyGroupId, this.lobbyGroupNameId, this.regionId, this.createTs, this.isReady, this.isIdle, this.isClosed, this.isOutdated, this.maxPlayersNormal, this.maxPlayersDirect, this.maxPlayersParty, this.totalPlayerCount, this.registeredPlayerCount);
        }
    }

    public static interface _FinalStage {
        public LobbySummaryAnalytics build();
    }

    public static interface RegisteredPlayerCountStage {
        public _FinalStage registeredPlayerCount(int var1);
    }

    public static interface TotalPlayerCountStage {
        public RegisteredPlayerCountStage totalPlayerCount(int var1);
    }

    public static interface MaxPlayersPartyStage {
        public TotalPlayerCountStage maxPlayersParty(int var1);
    }

    public static interface MaxPlayersDirectStage {
        public MaxPlayersPartyStage maxPlayersDirect(int var1);
    }

    public static interface MaxPlayersNormalStage {
        public MaxPlayersDirectStage maxPlayersNormal(int var1);
    }

    public static interface IsOutdatedStage {
        public MaxPlayersNormalStage isOutdated(boolean var1);
    }

    public static interface IsClosedStage {
        public IsOutdatedStage isClosed(boolean var1);
    }

    public static interface IsIdleStage {
        public IsClosedStage isIdle(boolean var1);
    }

    public static interface IsReadyStage {
        public IsIdleStage isReady(boolean var1);
    }

    public static interface CreateTsStage {
        public IsReadyStage createTs(OffsetDateTime var1);
    }

    public static interface RegionIdStage {
        public CreateTsStage regionId(UUID var1);
    }

    public static interface LobbyGroupNameIdStage {
        public RegionIdStage lobbyGroupNameId(String var1);
    }

    public static interface LobbyGroupIdStage {
        public LobbyGroupNameIdStage lobbyGroupId(UUID var1);
    }

    public static interface LobbyIdStage {
        public LobbyGroupIdStage lobbyId(UUID var1);

        public Builder from(LobbySummaryAnalytics var1);
    }
}

