/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.maven.plugin.session.impl;

import gg.nils.semanticrelease.maven.plugin.session.Session;
import gg.nils.semanticrelease.maven.plugin.util.GAV;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.simpleframework.xml.Default;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

@Root(name="semantic-version")
@Default(value=DefaultType.FIELD)
public class SessionImpl
implements Session {
    @Element(name="calculatedVersion")
    private String version;
    @Element(name="multiModuleProjectDirectory")
    private File multiModuleDirectory;
    @ElementList(name="projects", entry="gav")
    private Set<GAV> projects = new LinkedHashSet<GAV>();

    SessionImpl() {
    }

    public SessionImpl(String version, File multiModuleDirectory) {
        this.version = version;
        this.multiModuleDirectory = multiModuleDirectory;
    }

    public static String serializeTo(Session session) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        StringWriter sw = new StringWriter();
        serializer.write((Object)session, (Writer)sw);
        return sw.toString();
    }

    public static Session serializeFrom(String content) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        return (Session)serializer.read(SessionImpl.class, content);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public File getMultiModuleDirectory() {
        return this.multiModuleDirectory;
    }

    @Override
    public void addProject(GAV project) {
        this.projects.add(project);
    }

    @Override
    public Set<GAV> getProjects() {
        return Collections.unmodifiableSet(this.projects);
    }
}

