/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.mavenplugin.resolver;

import gg.nils.semanticrelease.api.error.SemanticReleaseException;
import gg.nils.semanticrelease.mavenplugin.resolver.MavenRepositoryResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=MavenRepositoryResolver.class)
public class DefaultMavenRepositoryResolver
implements MavenRepositoryResolver {
    @Inject
    private Logger logger;
    private Set<String> gaList = new HashSet<String>();
    private Set<Model> models = new HashSet<Model>();

    @Override
    public void resolve(Model startingPoint) {
        this.models = new HashSet<Model>();
        if (startingPoint.getParent() != null) {
            this.logger.info("startingPoint is not parent, resolving parent...");
            try {
                File pomFile = this.pomFile(startingPoint.getProjectDirectory(), startingPoint.getParent().getRelativePath());
                this.logger.debug("[PARENT] pomFile: " + pomFile.getPath());
                Model model = this.readModel(pomFile);
                this.logger.debug("[PARENT] model: " + model);
                this.logger.debug("[PARENT] resolved parent: " + model.getProjectDirectory());
                this.resolve(model);
                return;
            }
            catch (IOException e) {
                throw new SemanticReleaseException("Could not resolve " + startingPoint.getProjectDirectory(), (Throwable)e);
            }
        }
        if (startingPoint.getModules() == null || startingPoint.getModules().isEmpty()) {
            this.logger.info("no modules defined, probably a single project structure - returning only startingPoint");
            this.models.add(startingPoint);
            this.gaList.add(this.getGA(startingPoint));
            return;
        }
        this.models.add(startingPoint);
        this.gaList.add(this.getGA(startingPoint));
        for (String module : startingPoint.getModules()) {
            try {
                File pomFile = this.pomFile(startingPoint.getProjectDirectory(), module);
                this.logger.debug("[MODULE-" + module + "] pomFile: " + pomFile.getPath());
                Model model = this.readModel(pomFile);
                this.logger.debug("[MODULE-" + module + "] model: " + model);
                this.models.add(model);
                this.gaList.add(this.getGA(model));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(File pomFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(pomFile);){
            Model model = new MavenXpp3Reader().read((InputStream)inputStream);
            model.setPomFile(pomFile);
            Model model2 = model;
            return model2;
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    private File pomFile(File workingDirectory, String relativePath) {
        File modulePomFile = new File(workingDirectory, relativePath);
        if (modulePomFile.isDirectory()) {
            modulePomFile = new File(modulePomFile, "pom.xml");
        }
        return modulePomFile;
    }

    private String getGA(Model model) {
        String groupId = model.getParent() != null ? model.getParent().getGroupId() : model.getGroupId();
        String artifactId = model.getArtifactId();
        return groupId + ":" + artifactId;
    }

    private String getGA(Dependency dependency) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        return groupId + ":" + artifactId;
    }

    @Override
    public boolean isWithinProject(Model model) {
        String ga = this.getGA(model);
        return this.gaList.contains(ga);
    }

    @Override
    public boolean isWithinProject(Dependency dependency) {
        String ga = this.getGA(dependency);
        return this.gaList.contains(ga);
    }
}

