/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.mavenplugin;

import gg.nils.semanticrelease.api.config.DefaultSemanticReleaseConfig;
import gg.nils.semanticrelease.api.config.SemanticReleaseConfig;
import gg.nils.semanticrelease.api.versioncontrol.git.GitVersionControlProvider;
import gg.nils.semanticrelease.mavenplugin.resolver.MavenRepositoryResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Component(role=ModelProcessor.class)
public class SemanticVersionModelProcessor
extends DefaultModelProcessor {
    @Inject
    private Logger logger;
    @Inject
    @Parameter(defaultValue="${session}")
    private SessionScope sessionScope;
    @Inject
    private MavenRepositoryResolver mavenRepositoryResolver;
    private boolean initialized = false;
    private String finalVersion;

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.modifyModel(super.read(input, options), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.modifyModel(super.read(input, options), options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.modifyModel(super.read(input, options), options);
    }

    private Model modifyModel(Model model, Map<String, ?> options) {
        Object rawOption = options.get("org.apache.maven.model.building.source");
        if (!(rawOption instanceof FileModelSource)) {
            return model;
        }
        FileModelSource source = (FileModelSource)rawOption;
        if (source == null) {
            return model;
        }
        if (!this.initialized) {
            try {
                this.mavenRepositoryResolver.resolve(model);
            }
            catch (Throwable t) {
                this.logger.error("resolve called exception", t);
            }
            this.initialized = true;
        }
        if (!this.mavenRepositoryResolver.isWithinProject(model)) {
            return model;
        }
        this.logger.info("[" + model.getArtifactId() + "] modify " + model.getGroupId() + ":" + model.getArtifactId() + " in " + source.getFile());
        if (this.finalVersion == null) {
            FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(new File(source.getLocation()));
            if (repositoryBuilder.getGitDir() == null) {
                this.logger.warn("skip - not a git repository");
                return model;
            }
            try (Repository repository = repositoryBuilder.build();){
                Git git = new Git(repository);
                DefaultSemanticReleaseConfig config = new DefaultSemanticReleaseConfig();
                GitVersionControlProvider versionControlProvider = new GitVersionControlProvider((SemanticReleaseConfig)config, git);
                this.logger.debug("Current branch: " + versionControlProvider.getCurrentBranch());
                this.logger.debug("Actual version: " + model.getVersion());
                this.logger.debug("Latest tag: " + versionControlProvider.getLatestTag());
                this.logger.debug("Latest version: " + versionControlProvider.getLatestVersion());
                this.logger.debug("Next version: " + versionControlProvider.getNextVersion());
                this.logger.debug("Full version: " + versionControlProvider.getFullVersion());
                this.logger.debug("Full version w/o dirty: " + versionControlProvider.getFullVersionWithoutDirty());
                this.finalVersion = versionControlProvider.getFullVersionWithoutDirty();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.error("Could not generate version...", (Throwable)e);
                return model;
            }
        }
        if (model.getVersion() != null) {
            this.logger.info("[" + model.getArtifactId() + "] Set version from " + model.getVersion() + " to " + this.finalVersion);
            model.setVersion(this.finalVersion);
        }
        if (model.getParent() != null) {
            this.logger.info("[" + model.getArtifactId() + "] Set parent version from " + model.getParent().getVersion() + " to " + this.finalVersion);
            model.getParent().setVersion(this.finalVersion);
        }
        for (Dependency dependency : model.getDependencies()) {
            if (!this.mavenRepositoryResolver.isWithinProject(dependency)) continue;
            this.logger.info("[" + model.getArtifactId() + "] Set dependency version from " + dependency.getVersion() + " to " + this.finalVersion);
            dependency.setVersion(this.finalVersion);
        }
        return model;
    }
}

