/*
 * Decompiled with CFR 0.152.
 */
package gg.nils.semanticrelease.mavenplugin;

import gg.nils.semanticrelease.api.config.DefaultSemanticReleaseConfig;
import gg.nils.semanticrelease.api.config.SemanticReleaseConfig;
import gg.nils.semanticrelease.api.versioncontrol.git.GitVersionControlProvider;
import java.io.File;
import java.io.IOException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="semantic-release")
public class SemanticReleaseExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        String finalVersion;
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(new File(session.getRequest().getBaseDirectory()));
        if (repositoryBuilder.getGitDir() == null) {
            this.logger.warn("skip - not a git repository");
            return;
        }
        try (Repository repository = repositoryBuilder.build();){
            Git git = new Git(repository);
            DefaultSemanticReleaseConfig config = new DefaultSemanticReleaseConfig();
            GitVersionControlProvider versionControlProvider = new GitVersionControlProvider((SemanticReleaseConfig)config, git);
            this.logger.info("Current branch: " + versionControlProvider.getCurrentBranch());
            this.logger.info("Actual version: " + session.getCurrentProject().getVersion());
            this.logger.info("Latest version: " + versionControlProvider.getLatestVersion());
            this.logger.info("Next version: " + versionControlProvider.getNextVersion());
            this.logger.info("Full version: " + versionControlProvider.getFullVersion());
            finalVersion = versionControlProvider.getFullVersion();
        }
        catch (IOException e) {
            throw new MavenExecutionException("Could not generate version...", (Throwable)e);
        }
        for (MavenProject project : session.getAllProjects()) {
            project.setVersion(finalVersion);
        }
        super.afterProjectsRead(session);
    }
}

